#!/bin/csh -xf
#
set n0 = 
set n1 = ./evenangnik.dat
set n2 = ./newtiltshifts.dat
set n3 = 60000.0
set n4 = mjpartdata1.dat
set n5 = ./ctftilt.log
set n6 = ./selcmb.dat
set n7 = 
set n8 = 00.00
set n9 = 0.00
set n10 = 1
set n11 = 5088
set n12 = unteprniknorm_c_2.par
set n99 = ./tmp/
#
echo "$n0 = I:  empty"
echo "$n1 = I:  Spider file with image euler angles"
echo "$n2 = I:  Spider file with image shifts"
echo "$n3 = I:  image maginification"
echo "$n4 = I:  Spider file with image # and negative #"
echo "$n5 = I:  ctftilt log file"
echo "$n6 = I:  Spider file substack image #"
echo "$n7 = I:  empty"
echo "$n8 = I:  phase residual"
echo "$n9 = I:  phase residual difference (previous - current)"
echo "$n10 = I:  starting particle #"
echo "$n11 = I:  last particle #"
echo "$n12 = I:  Output file"
echo "$n99 = I:  temp directory"


echo "Calculate total particle number."
@ tpn = ($n11 - $n10) + 1

echo "Setup files and variables for loop."
set i = $n10
set nnp = 1

echo "Parse the ctftilt log."
echo "Generate defocus, astigmatism file, and tilt file."
#grep "Final Values" $n5 | cat -n > ${n99}/tempfinval.txt
echo "Generate image center x file."
#grep "CENTER_X" $n5 | cat -n > ${n99}/tempcenx.txt
echo "Generate image center y file."
#grep "CENTER_X" $n5 | cat -n > ${n99}/tempceny.txt
echo "Generate image pixel size."
#grep "PIXEL SIZE" $n5 | cat -n > ${n99}/temppixsize.txt

echo "Set counter."
set j=0

echo "Run loop to gather data for frealign."
while ($j <= $tpn)

echo "Get angles."
set psi = `awk '{if ($1=='$i') print $3}' $n1`
set theta = `awk '{if ($1=='$i') print $4}' $n1`
set phi = `awk '{if ($1=='$i') print $5}' $n1`

echo "Get shifts."
#set xsh = `awk '{if ($1=='$i') print $3}' $n2` 
#set ysh = `awk '{if ($1=='$i') print $4}' $n2`

echo "Get substack image #."
#set in = `awk '{if ($1=='$i') printf "%5d", $3}' $n6`
#echo $in

echo "Get negative #."
#set nn = `awk '{if ($1=='$in') print $3}' $n4`
#echo $nn

echo "Get astigmatism and calculate defocus values."
echo "Set first negative # and create temp. file."
if ( $i == $n10 ) then
#set fnn = $nn
echo "" > ${n99}/temp1.txt
endif

echo "Set negative # position."
#set nnp = `echo "" | awk '{printf ('${nn}' - '${fnn}' + 1)}'`
#echo $nnp
echo "Get astigmatism."
#set astig = `awk '{if ($1=='$nnp') print $4}' ${n99}/tempfinval.txt`

echo "Calculate defocus values."
#set dfmid1 = `awk '{if ($1=='$nnp') print $2}' ${n99}/tempfinval.txt`
#set dfmid2 = `awk '{if ($1=='$nnp') print $3}' ${n99}/tempfinval.txt`
#set tltaxis = `awk '{if ($1=='$nnp') print $5}' ${n99}/tempfinval.txt`
#set tltang = `awk '{if ($1=='$nnp') print $6}' ${n99}/tempfinval.txt`
#set cenx = `awk '{if ($1=='$nnp') print $6}' ${n99}/tempcenx.txt`
#set ceny = `awk '{if ($1=='$nnp') print $6}' ${n99}/tempceny.txt`
#set pixsize = `awk '{if ($1=='$nnp') print $8}' ${n99}/temppixsize.txt`
#set coorx = `awk '{if ($1=='$in') print $4}' ${n4}`
#set coory = `awk '{if ($1=='$in') print $5}' ${n4}`

#set deflow = `echo "" | awk '{printf "%9.1f", ((-sin('${tltaxis}' / #57.29577951) * ('${cenx}' - '${coorx}') + cos('${tltaxis}' / 57.29577951) * #('${ceny}' - '${coorx}')) * '${pixsize}' * sin('${tltang}' / 57.29577951) / #cos('${tltang}' / 57.29577951) + '${dfmid1}')}'`
#set defhigh = `echo "" | awk '{printf "%9.1f", ((-sin('${tltaxis}' / #57.29577951) * ('${cenx}' - '${coorx}') + cos('${tltaxis}' / 57.29577951) * ('${ceny}' - '${coorx}')) * '${pixsize}' * sin('${tltang}' / 57.29577951) / #cos('${tltang}' / 57.29577951) + '${dfmid2}')}'`

echo "Generate formatted parameter data for particle $i."
echo "" | awk '{printf "%7d%8.2f%8.2f%8.2f%8.2f%8.2f%7s%s%6d%9.1f%9.1f%8.2f%7.2f\n",'${i}',-'${psi}',-'${theta}',-'${phi}',0,0,'${n3}',".",1,0,0,0,0.0 }' > ${n99}/temp2.txt

echo "Generate list from parameter data."
cat ${n99}/temp1.txt ${n99}/temp2.txt > ${n99}/temp3.txt
cp ${n99}/temp3.txt ${n99}/temp1.txt


@ i = $i + 1
@ j = $j + 1

@ clean = `cat -n ${n99}/temp1.txt | tail -1 | awk '{print $1}'` - 1

echo "Rename temp. parameter file."
tail -$clean ${n99}/temp1.txt > $n12

echo "Delete temp files."
#rm ${n99}/

end


