#!/bin/csh -f
setenv IMAGIC_BATCH
set particles = "/nexsan1/mwolf/scans/HPV6/CM12/imagic/mralign5"
set ctf = "/nexsan1/mwolf/scans/HPV6/CM12/3x/fft_diag.log"
set classort = "/nexsan1/mwolf/scans/HPV6/CM12/imagic/classums_5_32"
set out = "HPV6_0_test.par"
#
# echo "! "
# echo "! IMAGIC-PROGRAM : stand:headers.e "
# echo "! "
#  get history to find original film number > temp2.doc
#
$IMAGIC_ROOT/stand/headers.e << EOF > temp2.doc
$particles
READ
STORY
EOF
#
# echo "! "
# echo "! IMAGIC-PROGRAM : stand:headers.e "
# echo "! "
#  get assigned class for each image > temp1.plt
#
$IMAGIC_ROOT/stand/headers.e << EOF > /dev/null
$particles
PLT
MSA
temp1.plt
EOF
#
# echo "! "
# echo "! IMAGIC-PROGRAM : stand:headers.e "
# echo "! "
#  get angle, x,y shifts for each particle > temp3.doc
#  (get reference number each particle was aligned against > temp2.plt)
#
$IMAGIC_ROOT/stand/headers.e << EOF > temp3.doc
$particles
PLT
ALIGN
temp2.plt
EOF
#
# echo "!  "
# echo "! -------------------- IMAGIC ACCUMULATE FILE-------------------- "
# echo "! "
# echo "! IMAGIC-PROGRAM : stand:headers.e "
# echo "! "
#  sort euler angles
#
$IMAGIC_ROOT/incore/excopy.e <<EOF > /dev/null
SORT
$classort
temp1
CLASS
UP
0
EOF
# echo "! "
# echo "! IMAGIC-PROGRAM : stand:headers.e "
# echo "! "
$IMAGIC_ROOT/stand/headers.e <<EOF > /dev/null
temp1
PLT
EULER
temp3.plt
EOF
#
#  create list with particles and film numbers > temp1.doc
grep mrc temp2.doc | awk -F".mrc" '{ print $1}' \
| awk '{ i++; len =length($0); print "p", i, substr($0, len-3) }' \
> temp1.doc
#
\rm $out
# exit
set np = `wc -l temp1.doc | awk '{ print $1 }'`
set offset = `grep -n "X-shift" temp3.doc | head -1 | awk -F: '{ print $1 }'`
echo "$np particles"
set i = 1
while ($i <= $np)
  set file = `grep "p $i " temp1.doc | awk '{ print $3 }'`
  set class = `head -n$i temp1.plt | tail -n1 | awk -F. '{ print $1}'`
  set eul = `head -n$class temp3.plt | tail -n1`
  set e1 = `echo $eul | awk '{ print $1 }'`
  set e2 = `echo $eul | awk '{ print $2 }'`
  set e3 = `echo $eul | awk '{ print $3 }'`
  @ ii = $i + $offset + 2
  set axy = `head -n$ii temp3.doc | tail -n1`
  set ang = `echo $axy | awk '{ print $6 }'`
  set y = `echo $axy | awk '{ print  $7*cos('${ang}'*0.017453292) - $8*sin('${ang}'*0.017453292) }'`
  set x = `echo $axy | awk '{ print -$7*sin('${ang}'*0.017453292) - $8*cos('${ang}'*0.017453292) }'`
#  set x = `echo $axy | awk '{ print -$8 }'`
#  set y = `echo $axy | awk '{ print -$7 }'`
#  set ref = `echo $axy | awk '{ print $9 }'`
#  set eul = `head -n$ref temp3.plt | tail -n1`
#  set e1 = `echo $eul | awk '{ print $1 }'`
#  set e2 = `echo $eul | awk '{ print $2 }'`
#  set e3 = `echo $eul | awk '{ print $3 }'`
  set e11 = `echo $ang | awk '{ print '${e1}' - $1 }'`
  echo $i $e11 $e2 $e3 $x $y $file.mrc $class $ang
  grep -e "Final" -e $file.mrc $ctf \
  | awk '{ if (match($0,"image") > 0) i++; if (i > 0) print $0 }' \
  | awk '{ i++; if (i == 3) printf "%7d%8.2f%8.2f%8.2f%8.2f%8.2f%8s%6d%9.1f%9.1f%8.2f%7.2f\n",'${i}','${e11}' + 90.0,'${e2}','${e3}' - 90.0,'${x}','${y}',60000.,'${file}',$1,$2,$3,0.0 }' >> $out
  @ i = $i + 1
end
#
