#!/bin/csh -fx
# 
# This script will take the back projection angles and image
# shifts from the untilted and tilted image stacks of a  
# random conical tilt procedure and combine them for use in
# frealign.

###########
# VARIABLES
###########

set n1 = 1
set n2 = 917
set n3 = 1318
set ext = dat
set tshfdoc = newtiltshifts
set tangdoc = newbpang
set ushfdoc = newuntiltshifts
set uangdoc = newutbpang
set cmbshfdoc = cmbshfdoc
set cmbangdoc = cmbangdoc
set tstk = tcutshift00917
set ustk = ucutcmb01318
set cmbstk = cmbstk
set ang_per_pix = 4.66667

echo "$n1 = I:  First image #."
echo "$n2 = I:  Last tilted image #."
echo "$n3 = I:  Last untilted image #."
echo "$ext = I:  Spider extension for data files."
echo "$tshfdoc = I:  Tilt image shift doc. file."
echo "$tshfdoc = I:  Tilt image back proj. angle doc. file."
echo "$ushfdoc = I:  Untilt image shift doc. file."
echo "$ushfdoc = I:  Untilt image back proj. angle doc. file."
echo "$cmbshfdoc = I:  Combined shift doc. file."
echo "$cmbangdoc = I:  Combined back proj. angle doc. file."
echo "$tstk = I:  Tilted image stack."
echo "$ustk = I:  Untilted image stack."
echo "$cmbstk = I:  Combined image stack."
echo "$ang_per_pix = I:  Pixel spacing of images."

##########
# PROGRAM
##########

echo "Determine OS being used."
set OS = `echo $OSTYPE`
if ($OS == "osf1") set spider   = "${SPIDER_LOC}spider_dec"
if ($OS == "linux") set spider   = "${SPIDER_LOC}spider_linux"
printf "\nRunning on a $OSTYPE machine\n"

echo "Copy cmbtiltpair.prj to working directory."
cp /nexsan1/bin/TWfetch/SPIDER/templates/cmbtiltpair.prj ./

echo "Run cmbtiltpair.prj."
$spider <<EOSc
prj/$ext
@cmbtiltpair
$n1
$n2
$n3
$tshfdoc
$tangdoc
$ushfdoc
$uangdoc
$cmbshfdoc
$cmbangdoc
$tstk
$ustk
$cmbstk
en
EOSc

#echo "Copy addeuler to working directory."
#cp /nexsan1/bin/TWfetch/SPIDER/templates/addeuler.prj ./

echo "Determine last image #."
set n4 = `tail -1  ${cmbshfdoc}.${ext} | awk '{print $1}'`

echo "Run addeuler.prj."
$spider <<EOSc
prj/$ext
@addeuler
$n1
$n4
$cmbangdoc
none
frecmbangdoc
en
EOSc

echo "Create mrc formatted image stack."
echo "Create unstk.prj."
sed "s;IMG_NUM;$n4;" /nexsan1/bin/TWfetch/SPIDER/templates/unstk.tmp | sed "s;IMG_STK;$cmbstk;" > unstk.prj

echo "Run unstk.prj."
$spider <<EOSc
prj/$ext
@unstk
en
EOSc

echo "Create move.com."
sed "s;FIRST_IMG;$n1;" /nexsan1/bin/TWfetch/SPIDER/templates/move.tmp | sed "s;LAST_IMG;$n4;" | sed "s;IMG_STK;./unstacked/$cmbstk;" | sed "s;IMG_STK;./unstacked/$cmbstk;" | sed "s;EXT;$ext;" | sed "s;EXT;$ext;" > move.com

echo "Run move.com."
chmod 755 move.com
move.com >& move.log

echo "Create spi2mrcstk.com."
sed "s;FIRST_IMG;$n1;" /nexsan1/bin/TWfetch/SPIDER/templates/spi2mrcstk.tmp | sed "s;LAST_IMG;$n4;" | sed "s;ANG_PER_PIX;$ang_per_pix;" | sed "s;IMG_ROOT;./unstacked/$cmbstk;" | sed "s;EXT;$ext;" > spi2mrcstk.com

echo "Run spi2mrcstk.com."
chmod 755 spi2mrcstk.com
spi2mrcstk.com >& spi2mrcstk.log 

rm *X.* LOG*
