#!/bin/csh -x
#
set bindir = ../../bin
set cdir = `pwd`
set SCRATCH = ../scratch
cd $SCRATCH
#
#   This job requires 2 seconds per particle (AMD Opteron) to determine orientations
#      from scratch, so 200 particles take about 7 minutes.
#
\rm -f pdh_shifts_2.shft
\rm -f pdh_2.par
\rm -f pdh_weights_2
cp -p ${cdir}/../pdh_1.mrc pdh_2.mrc
#
time ${bindir}/frealign_v9.exe << eot
M,-3,F,F,F,F,0,T,T,F,T,0,F,3,1				!CFORM,IFLAG,FMAG,FDEF,FASTIG,FPART,IEWALD,FBEAUT,FFILT,FBFACT,FMATCH,IFSC,FDUMP,IMEM,INTERP
146.,0.,3.11,1500.0,0.07,0.,100.,35.,15.,20,20		!RO,RI,PSIZE,WGH,XSTD,PBC,BOFF,DANG,ITMAX,IPMAX
1,1,1,1,1						!MASK
1,200							!IFIRST,ILAST 
I							!ASYM symmetry card (I=icosahedral)
1., 14.0, 25., 0., 2., 120., 0., 0.			!RELMAG,DSTEP,TARGET,THRESH,CS,AKV,TX,TY
10.0, 100.0, 35.0, 150.0, 0.				!RREC,RMIN,RMAX,DFSIG,RBFACT
${cdir}/../pdh_stack.mrc
pdh_match.mrc
200,45000.,926,18500,18500,45.,0			!NIN,ABSMAGPIN,IFILMIN,DFMID1IN,DFMID2IN,ANGASTIN,MORE
pdh_2.par
pdh_2.shft
0., 0., 0., 0., 0., 0., 0., 0.				!terminator with RELMAG=0.0
pdh_2.mrc
pdh_weights_2
pdh_map1_2
pdh_map2_2
pdh_phasediffs_2
pdh_pointspread_2
eot
#
cp pdh_2.par ${cdir}
cp pdh_2.mrc ${cdir}
