#!/bin/csh -x
#
#   Control script to submit multiple jobs on a cluster using
#   the Sun Grid Engine. Each job processes N particles. N is
#   specified in the 'mparameters' file as 'increment'.
#
cp mparameters mparameters_run

set start	= `grep start_process mparameters_run | awk '{print $2}'`
set end		= `grep end_process mparameters_run | awk '{print $2}'`
set first	= `grep first_particle mparameters_run | awk '{print $2}'`
set last	= `grep last_particle mparameters_run | awk '{print $2}'`
set data_input	= `grep data_input mparameters_run | awk '{print $2}'`
set nclass	= `grep nclasses mparameters_run | awk '{print $2}'`
set bindir      = ../../bin
set working_directory = `pwd`
set SCRATCH = ${working_directory}/../scratch

mainloop:

cp mparameters mparameters_run
set incr	= `grep increment mparameters_run | awk '{print $2}'`

reconstruct:
echo "Calculating 3D structure...."

set npart = 0
set firstn = $first
@ lastn = $first + $incr - 1

while ( $lastn <= $last )
  echo "Submitted reconstruction for particles " $firstn to $lastn on `date`
  @ npart++

  set nc = 1
  while ( $nc <= $nclass )
    \rm $SCRATCH/${data_input}_mult_reconstruct_r${nc}_p${firstn}.log >& /dev/null
    \rm $SCRATCH/${data_input}_${start}_r${nc}.shft_* >& /dev/null
    \rm $SCRATCH/${data_input}_mult_refine_n_r${nc}.log_* >& /dev/null
    qsub -l mem_free=1G -cwd -r y -V -e $SCRATCH/stderr -o $SCRATCH/stderr -N r${nc}_${firstn} $working_directory/mult_reconstruct_p.com $firstn $lastn $start $nc
    @ nc++
  end

#  sleep 2

  if ( $lastn == $last ) then
    goto submission_done
  endif
  @ firstn = $firstn + $incr
  @ lastn = $lastn + $incr
  if ( $firstn >= $last ) set firstn = $last
  if ( $lastn >= $last ) set lastn = $last
end

submission_done:

set nc = 1
while ( $nc <= $nclass )

  set firstn = $first
  @ lastn = $first + $incr - 1

checkdone_rec:

  sleep 5
  while ( $firstn <= $last )

    grep --binary-files=text finished $SCRATCH/${data_input}_mult_reconstruct_r${nc}_p${firstn}.log >& /dev/null

    if ($status) goto checkdone_rec

    echo "Reconstruction for particles $firstn to $lastn, ref $nc, finished....  "`date`

    @ firstn = $firstn + $incr
    @ lastn = $lastn + $incr
    if ( $lastn >= $last ) set lastn = $last
  end

  @ nc++

end

set nc = 1
while ( $nc <= $nclass )

  echo $npart > $SCRATCH/merge_3d_r${nc}.in
  set firstn = $first
  @ lastn = $first + $incr - 1
  while ( $firstn <= $last )

    echo ${data_input}_${start}_r${nc}_p${firstn}.mrc >> $SCRATCH/merge_3d_r${nc}.in

    @ firstn = $firstn + $incr
    @ lastn = $lastn + $incr
    if ( $lastn >= $last ) set lastn = $last

  end

  echo ${data_input}_${start}_r${nc}.res >> $SCRATCH/merge_3d_r${nc}.in
  echo ${data_input}_${start}_r${nc}.mrc >> $SCRATCH/merge_3d_r${nc}.in
  echo ${data_input}_${start}_r${nc}_weights >> $SCRATCH/merge_3d_r${nc}.in
  echo ${data_input}_${start}_r${nc}_map1.mrc >> $SCRATCH/merge_3d_r${nc}.in
  echo ${data_input}_${start}_r${nc}_map2.mrc >> $SCRATCH/merge_3d_r${nc}.in
  echo ${data_input}_${start}_r${nc}_phasediffs >> $SCRATCH/merge_3d_r${nc}.in
  echo ${data_input}_${start}_r${nc}_pointspread >> $SCRATCH/merge_3d_r${nc}.in

  cp ${data_input}_${start}_r${nc}_p${first}.res ${data_input}_${start}_r${nc}.res

  qsub -pe batch 2 -l mem_free=2G -cwd -r y -V -e $SCRATCH/stderr -o $SCRATCH/stderr -N m${nc} ${working_directory}/merge_3d.com ${nc}

  @ nc++

end
  
set nc = 1
while ( $nc <= $nclass )
  
checkdonem:

  sleep 2

  grep --binary-files=text "merge_3d.com finished" $SCRATCH/merge_3d_r${nc}.log >& /dev/null
  if ($status) goto checkdonem

  ls $SCRATCH/${data_input}_${start}_r${nc}.mrc >& /dev/null
  if ($status) goto checkdonem

  ls $SCRATCH/${data_input}_${start}_r${nc}.res >& /dev/null
  if ($status) goto checkdonem

  sleep 1

  cat $SCRATCH/${data_input}_${start}_r${nc}.res >> ${working_directory}/${data_input}_${start}_r${nc}.par
  mv $SCRATCH/${data_input}_${start}_r${nc}.mrc ${working_directory}/${data_input}_${start}_r${nc}.mrc
  \rm $SCRATCH/${data_input}_${start}_r${nc}.res
  \rm $SCRATCH/${data_input}_${start}_r${nc}.par

  @ nc++

end

# Clean up

set nc = 1
while ( $nc <= $nclass )

  set firstn = $first
  @ lastn = $first + $incr - 1
  while ( $firstn <= $last )

    \rm $SCRATCH/${data_input}_${start}_r${nc}_p${firstn}.mrc
    \rm $SCRATCH/${data_input}_${start}_r${nc}_p${firstn}.res

    @ firstn = $firstn + $incr
    @ lastn = $lastn + $incr
    if ( $lastn >= $last ) set lastn = $last

  end

  @ nc++

end

date
