#!/bin/csh
#unlimit
limit coredumpsize 0
set bindir = ../../bin
set working_directory = `grep working_directory mparameters_run | awk '{print $2}'`
if (${working_directory} == ".") set working_directory = `pwd`
cd ${working_directory}
#
set start = $3
set data_input	= `grep data_input mparameters_run | awk '{print $2}'`
set raw_images	= `grep raw_images_high mparameters_run | awk '{print $2}'`
set target	= `grep thresh_refine mparameters_run | awk '{print $2}'`
set pbc		= `grep PBC mparameters_run | awk '{print $2}'`
set boff	= `grep BOFF mparameters_run | awk '{print $2}'`
set dang	= `grep DANG mparameters_run | awk '{print $2}'`
set itmax	= `grep ITMAX mparameters_run | awk '{print $2}'`
set mode	= `grep MODE mparameters_run | awk '{print $2}'`
set FPART	= `grep FPART mparameters_run | awk '{print $2}'`
set FMATCH	= `grep FMATCH mparameters_run | awk '{print $2}'`
set rrec	= `grep res_reconstruction mparameters_run | awk '{print $2}'`
set rref	= `grep res_high_refinement mparameters_run | awk '{print $2}'`
set rlowref	= `grep res_low_refinement mparameters_run | awk '{print $2}'`
set rbf		= `grep RBfactor mparameters_run | awk '{print $2}'`
set sym		= `grep Sym mparameters_run | awk '{print $2}'`
set pix		= `grep pix_size mparameters_run | awk '{print $2}'`
set kV		= `grep kV mparameters_run | awk '{print $2}'`
set AmpC	= `grep Amp_contrast mparameters_run | awk '{print $2}'`
set XSTD	= `grep XSTD mparameters_run | awk '{print $2}'`
set dstep	= `grep dstep mparameters_run | awk '{print $2}'`
set ro		= `grep outer_radius mparameters_run | awk '{print $2}'`
set ri		= `grep inner_radius mparameters_run | awk '{print $2}'`
set MW		= `grep mol_mass mparameters_run | awk '{print $2}'`
set cs		= `grep Cs mparameters_run | awk '{print $2}'`
set mode	= ${4}
set psi		= ${5}
set theta	= ${6}
set phi		= ${7}
set shx		= ${8}
set shy		= ${9}
#
set SCRATCH = ${working_directory}/../scratch

if (${mode} == "") set mode = 1

### check for shift & angle refinement
if (${psi} == "") set psi = 1
if (${theta} == "") set theta = 1
if (${phi} == "") set phi = 1
if (${shx} == "") set shx = 1
if (${shy} == "") set shy = 1

@ prev = $start - 1
cd $SCRATCH
#
\rm ${data_input}_${start}.par_${1}_${2} >& /dev/null
#
time ${bindir}/frealign_v9.exe << eot >& ${data_input}_mrefine_n.log_${1}_${2}
M,${mode},F,F,F,${FPART},0,F,F,F,${FMATCH},0,F,3,1			!CFORM,IFLAG,FMAG,FDEF,FASTIG,FPART,IEWALD,FBEAUT,FFILT,FBFACT,FMATCH,IFSC,FDUMP,IMEM,INTERP
${ro},${ri},${pix},${MW},${AmpC},${XSTD},${pbc},${boff},${dang},${itmax},20	!RO,RI,PSIZE,WGH,XSTD,PBC,BOFF,DANG,ITMAX,IPMAX
${psi},${theta},${phi},${shx},${shy}					!MASK
${1},${2}								!IFIRST,ILAST
${sym}									!ASYM symmetry card (I=icosahedral)
1.0,${dstep},${target},0.0,${cs},${kV},0.0,0.0				!RELMAG,DSTEP,TARGET,THRESH,CS,AKV,TX,TY
${rrec},   ${rlowref},   ${rref}, 100.0, ${rbf}				!RREC,RMIN,RMAX,DFSTD,RBFACT
${working_directory}/../${raw_images}.mrc
${data_input}_reproject.mrc_${1}_${2}
200,45000.,926,18500,18500,45.,0					!NIN,ABSMAGPIN,IFILMIN,DFMID1IN,DFMID2IN,ANGASTIN,MORE
${data_input}_${start}.par_${1}_${2}
${data_input}_${start}.shft_${1}_${2}
-100., 0., 0., 0., 0., 0., 0., 0.					! terminator with RELMAG=0.0
${working_directory}/${data_input}_${prev}.mrc
${data_input}_${start}_weights
${data_input}_${start}_map1.mrc
${data_input}_${start}_map2.mrc
${data_input}_${start}_phasediffs
${data_input}_${start}_pointspread
eot
#
echo Job on $HOST finished >> $SCRATCH/stderr
#
