#!/bin/csh -x
#
#   Control script to submit multiple jobs on a cluster using
#   the Sun Grid Engine. Each job processes N particles. N is
#   specified in the 'mparameters' file as 'increment'.
#
cp mparameters mparameters_run

set start	= `grep start_process mparameters_run | awk '{print $2}'`
set end		= `grep end_process mparameters_run | awk '{print $2}'`
set first	= `grep first_particle mparameters_run | awk '{print $2}'`
set last	= `grep last_particle mparameters_run | awk '{print $2}'`
set data_input	= `grep data_input mparameters_run | awk '{print $2}'`
set nclass	= `grep nclasses mparameters_run | awk '{print $2}'`
set working_directory = `pwd`
set SCRATCH = ${working_directory}/../scratch

cp -p ${working_directory}/../pdh_1.mrc pdh_1.mrc

if ( ! -d $SCRATCH ) then
  mkdir $SCRATCH
endif

mainloop:

cp mparameters mparameters_run
set incr	= `grep increment mparameters_run | awk '{print $2}'`
set itmax	= `grep ITMAX mparameters_run | awk '{print $2}'`
set refineshiftinc = `grep refineshiftinc mparameters_run | awk '{print $2}'`
set refineangleinc = `grep refineangleinc mparameters_run | awk '{print $2}'`
set mode	= `grep MODE mparameters_run | awk '{print $2}'`

\rm ${data_input}_${start}.par >& /dev/null

# queue submission loop

@ prev = $start - 1

set firstn = $first
@ lastn = $first + $incr - 1

while ( $lastn <= $last )
  echo "Submitted particles from" $firstn to $lastn on `date`

  $working_directory/mrefine_n.com $firstn $lastn $start $mode 1 1 1 1 1 1 &
#  qsub -l mem_free=1G -cwd -r y -V -e $SCRATCH/stderr -o $SCRATCH/stderr -N n${nc}_${firstn} $working_directory/mrefine_n.com $firstn $lastn $start $mode 1 1 1 1 1 1

#  sleep 2

  if ( $lastn == $last ) then
    goto alignment_done
  endif
  @ firstn = $firstn + $incr
  @ lastn = $lastn + $incr
  if ( $firstn >= $last ) set firstn = $last
  if ( $lastn >= $last ) set lastn = $last
end

alignment_done:

set firstn = $first
@ lastn = $first + $incr - 1

checkdone:

  sleep 5
  while ( $firstn <= $last )

    grep --binary-files=text "overall score" $SCRATCH/${data_input}_${start}.par_${firstn}_$lastn >& /dev/null

    if ($status) goto checkdone

    echo "Particles $firstn to $lastn, finished....  "`date`
    if ($firstn == $first ) head -65 $SCRATCH/${data_input}_${start}.par_${firstn}_${lastn} | grep --binary-files=text C >> ${data_input}_${start}.par

    grep -v C --binary-files=text $SCRATCH/${data_input}_${start}.par_${firstn}_${lastn} >> ${data_input}_${start}.par
    \rm $SCRATCH/${data_input}_${start}.par_${firstn}_${lastn} >& /dev/null

    @ firstn = $firstn + $incr
    @ lastn = $lastn + $incr
    if ( $lastn >= $last ) set lastn = $last
  end

collect_done:

reconstruct:
echo "Calculating 3D structure...."

  \rm $SCRATCH/${data_input}_mreconstruct_${prev}.log
  \rm $SCRATCH/${data_input}_${start}.shft_*
  \rm $SCRATCH/${data_input}_mrefine_n.log_*
  ${working_directory}/mreconstruct.com $first $last $start &
#  qsub -pe batch 4 -l mem_free=2G -cwd -r y -V -e $SCRATCH/stderr -o $SCRATCH/stderr -N r${nc} ${working_directory}/mreconstruct.com $first $last $start

checkdoner:

  sleep 2

  grep --binary-files=text "mreconstruct.com finished" $SCRATCH/${data_input}_mreconstruct.log >& /dev/null
  if ($status) goto checkdoner

  ls ${working_directory}/${data_input}_${start}.mrc >& /dev/null
  if ($status) goto checkdoner

  ls $SCRATCH/${data_input}_${start}.res >& /dev/null
  if ($status) goto checkdoner

  sleep 1

  cat $SCRATCH/${data_input}_${start}.res >> ${working_directory}/${data_input}_${start}.par
  \rm $SCRATCH/${data_input}_${start}.res
  \rm $SCRATCH/${data_input}_${start}.par

sleep 10

if ($start < $end ) then
  @ start = $start + 1
  goto mainloop
endif
date
