#!/bin/csh
#
#   Control script to submit multiple jobs on a cluster using
#   the Sun Grid Engine. Each job processes a sampled set of
#   particles.
#
cp mparameters mparameters_run

set start	= `grep start_process mparameters_run | awk '{print $2}'`
set first	= `grep first_particle mparameters_run | awk '{print $2}'`
set last	= `grep last_particle mparameters_run | awk '{print $2}'`
set data_input	= `grep data_input mparameters_run | awk '{print $2}'`
set pix		= `grep pix_size mparameters_run | awk '{print $2}'`
set nclass	= `grep nclasses mparameters_run | awk '{print $2}'`
set working_directory = `pwd`
set bindir	= ../../bin
set SCRATCH	= ../scratch

@ prev = $start - 1

${bindir}/rsample.exe << eot
${data_input}_${prev}.par
${pix}
${nclass}
${data_input}_${prev}_r.par
eot

set nc = 1
while ( $nc <= $nclass )
  echo Submitting reconstruction job $nc
  qsub -pe batch 8 -l mem_free=2G -cwd -r y -V -e $SCRATCH/stderr -o $SCRATCH/stderr -N r$nc ${working_directory}/mult_reconstruct.com $first $last $prev $nc
  @ nc = $nc + 1
end

date
