#!/bin/csh -x
#
#   Control script to submit multiple jobs on a cluster using
#   the Sun Grid Engine. Each job processes N particles. N is
#   specified in the 'mparameters' file as 'increment'.
#
cp mparameters mparameters_run

set start	= `grep start_process mparameters_run | awk '{print $2}'`
set end		= `grep end_process mparameters_run | awk '{print $2}'`
set first	= `grep first_particle mparameters_run | awk '{print $2}'`
set last	= `grep last_particle mparameters_run | awk '{print $2}'`
set data_input	= `grep data_input mparameters_run | awk '{print $2}'`
set nclass	= `grep nclasses mparameters_run | awk '{print $2}'`
set bindir	= ../../bin
set working_directory = `pwd`
set SCRATCH = ${working_directory}/../scratch

if ( ! -d $SCRATCH ) then
  mkdir $SCRATCH
endif

mainloop:

cp mparameters mparameters_run
set incr	= `grep increment mparameters_run | awk '{print $2}'`
set itmax	= `grep ITMAX mparameters_run | awk '{print $2}'`
set refineshiftinc = `grep refineshiftinc mparameters_run | awk '{print $2}'`
set refineangleinc = `grep refineangleinc mparameters_run | awk '{print $2}'`
set mode	= `grep MODE mparameters_run | awk '{print $2}'`

set shiftiter = `expr ${start} % ${refineshiftinc}`
set angleiter = `expr ${start} % ${refineangleinc}`

if ( $mode != 1 ) then
  if (${shiftiter} == 0) then  
    if (${angleiter} == 0) then
      set incr = `expr ${incr} / ${itmax} \* 2`
    endif
  endif
endif

set nc = 1
while ( $nc <= $nclass )
  \rm ${data_input}_${start}_r${nc}.par >& /dev/null
  @ nc = $nc + 1
end

# queue submission loop

@ prev = $start - 1

set firstn = $first
@ lastn = $first + $incr - 1

while ( $lastn <= $last )
  echo "Submitted particles from" $firstn to $lastn on `date`

  set nc = 1
  while ( $nc <= $nclass )
    if (${shiftiter} == 0) then
      if (${angleiter} == 0) then
        qsub -l mem_free=5G -cwd -r y -V -e $SCRATCH/stderr -o $SCRATCH/stderr -N n${nc}_${firstn} $working_directory/mult_refine_n.com $firstn $lastn $start $nc $mode 1 1 1 1 1
      else if (${angleiter} != 0) then
        qsub -l mem_free=5G -cwd -r y -V -e $SCRATCH/stderr -o $SCRATCH/stderr -N n${nc}_${firstn} $working_directory/mult_refine_n.com $firstn $lastn $start $nc 1 0 0 0 1 1
      endif
    else if (${shiftiter} != 0) then
      if (${angleiter} == 0) then
        qsub -l mem_free=5G -cwd -r y -V -e $SCRATCH/stderr -o $SCRATCH/stderr -N n${nc}_${firstn} $working_directory/mult_refine_n.com $firstn $lastn $start $nc 1 1 1 1 0 0
      else if (${angleiter} != 0) then
        qsub -l mem_free=5G -cwd -r y -V -e $SCRATCH/stderr -o $SCRATCH/stderr -N n${nc}_${firstn} $working_directory/mult_refine_n.com $firstn $lastn $start $nc 1 0 0 0 0 0
      endif
    endif
    @ nc = $nc + 1
  end

#  sleep 2

  if ( $lastn == $last ) then
    goto alignment_done
  endif
  @ firstn = $firstn + $incr
  @ lastn = $lastn + $incr
  if ( $firstn >= $last ) set firstn = $last
  if ( $lastn >= $last ) set lastn = $last
end

alignment_done:

set nc = 1
while ( $nc <= $nclass )

  set firstn = $first
  @ lastn = $first + $incr - 1

checkdone:

  sleep 5
  while ( $firstn <= $last )

    grep --binary-files=text "overall score" $SCRATCH/${data_input}_${start}_r${nc}.par_${firstn}_$lastn >& /dev/null

    if ($status) goto checkdone

    echo "Particles $firstn to $lastn, ref $nc, finished....  "`date`
    if ($firstn == $first ) head -65 $SCRATCH/${data_input}_${start}_r${nc}.par_${firstn}_${lastn} | grep --binary-files=text C >> ${data_input}_${start}_r${nc}.par

    grep -v C --binary-files=text $SCRATCH/${data_input}_${start}_r${nc}.par_${firstn}_${lastn} >> ${data_input}_${start}_r${nc}.par
    \rm $SCRATCH/${data_input}_${start}_r${nc}.par_${firstn}_${lastn} >& /dev/null

    @ firstn = $firstn + $incr
    @ lastn = $lastn + $incr
    if ( $lastn >= $last ) set lastn = $last
  end

collect_done:

  @ nc = $nc + 1

end

if ($nclass <= 1) goto skip_occ

echo $nclass > calc_occ.in
echo 1.0 >> calc_occ.in
set nc = 1
while ($nc <= $nclass)
  echo ${data_input}_${start}_r${nc}.par >> calc_occ.in
  @ nc++
end
set nc = 1
while ($nc <= $nclass)
  echo ${data_input}_${start}_r${nc}.par >> calc_occ.in
  @ nc++
end

time ${bindir}/calc_occ.exe < calc_occ.in >& calc_occ.log
\rm calc_occ.in

skip_occ:

reconstruct:
echo "Calculating 3D structure...."

set nc = 1
while ( $nc <= $nclass )

  \rm $SCRATCH/${data_input}_mult_reconstruct_${prev}_r${nc}.log
  \rm $SCRATCH/${data_input}_${start}_r${nc}.shft_*
  \rm $SCRATCH/${data_input}_mult_refine_n_r${nc}.log_*
  qsub -pe batch 8 -l mem_free=2G -cwd -r y -V -e $SCRATCH/stderr -o $SCRATCH/stderr -N r${nc} ${working_directory}/mult_reconstruct.com $first $last $start $nc

  @ nc = $nc + 1

end

set nc = 1
while ( $nc <= $nclass )
  
checkdoner:

  sleep 2

  grep --binary-files=text "mreconstruct.com finished" $SCRATCH/${data_input}_mult_reconstruct_r${nc}.log >& /dev/null
  if ($status) goto checkdoner

  ls ${working_directory}/${data_input}_${start}_r${nc}.mrc >& /dev/null
  if ($status) goto checkdoner

  ls $SCRATCH/${data_input}_${start}_r${nc}.res >& /dev/null
  if ($status) goto checkdoner

  sleep 1

  cat $SCRATCH/${data_input}_${start}_r${nc}.res >> ${working_directory}/${data_input}_${start}_r${nc}.par
  \rm $SCRATCH/${data_input}_${start}_r${nc}.res
  \rm $SCRATCH/${data_input}_${start}_r${nc}.par

  @ nc = $nc + 1

end

sleep 10

if ($nclass <= 1) goto skip_occ2

echo $nclass > calc_occ.in
echo 1.0 >> calc_occ.in
set nc = 1
while ($nc <= $nclass)
  echo ${data_input}_${start}_r${nc}.par >> calc_occ.in
  @ nc++
end
set nc = 1
while ($nc <= $nclass)
  echo ${data_input}_${start}_r${nc}.par >> calc_occ.in
  @ nc++
end

time ${bindir}/calc_occ.exe < calc_occ.in >& calc_occ.log
\rm calc_occ.in

skip_occ2:

cp mparameters mparameters_run
set end		= `grep end_process mparameters_run | awk '{print $2}'`

if ($start < $end ) then
  @ start = $start + 1
  goto mainloop
endif
date
