#!/bin/csh
limit coredumpsize 0
set working_directory = `pwd`
#
set start = 50
@ prev = $start - 1
set data_input  = `grep data_input mparameters_run | awk '{print $2}'`
set raw_images1 = `grep raw_images1 mparameters_run | awk '{print $2}'`
set raw_images2 = `grep raw_images2 mparameters_run | awk '{print $2}'`
set raw_images3 = `grep raw_images3 mparameters_run | awk '{print $2}'`
set radius      = `grep radius mparameters_run | awk '{print $2}'`
set thresh1     = `grep thresh_reconst1 mparameters_run | awk '{print $2}'`
set thresh2     = `grep thresh_reconst2 mparameters_run | awk '{print $2}'`
set thresh3     = `grep thresh_reconst3 mparameters_run | awk '{print $2}'`
set pbc         = `grep PBC mparameters_run | awk '{print $2}'`
set boff        = `grep BOFF mparameters_run | awk '{print $2}'`
set dang        = `grep DANG mparameters_run | awk '{print $2}'`
set itmax       = `grep ITMAX mparameters_run | awk '{print $2}'`
set mode        = `grep MODE mparameters_run | awk '{print $2}'`
set flip        = `grep flip mparameters_run | awk '{print $2}'`
set rrec        = `grep res_reconstruction mparameters_run | awk '{print $2}'`
set rref        = `grep res_refinement mparameters_run | awk '{print $2}'`
set rbf		= `grep RBfactor mparameters_run | awk '{print $2}'`
set sym		= `grep Sym mparameters_run | awk '{print $2}'`
set pix1	= `grep pix_size1 mparameters_run | awk '{print $2}'`
set pix2	= `grep pix_size2 mparameters_run | awk '{print $2}'`
set pix3	= `grep pix_size3 mparameters_run | awk '{print $2}'`
set kV1         = `grep kV1 mparameters_run | awk '{print $2}'`
set kV2         = `grep kV2 mparameters_run | awk '{print $2}'`
set kV3         = `grep kV3 mparameters_run | awk '{print $2}'`
set AmpC        = `grep Amp_contrast mparameters_run | awk '{print $2}'`
set mask	= `grep mask mparameters_run | awk '{print $2}'`
set dstep	= `grep dstep mparameters_run | awk '{print $2}'`
set first	= `grep first_particle mparameters_run | awk '{print $2}'`
set last	= `grep last_particle mparameters_run | awk '{print $2}'`
#
\rm ${data_input}_$start.mrc
\rm ${data_input}_$start.res
#
time ~/frealign_v8.09/bin/frealign_v8.exe << eot
M,0,F,F,F,F,0,T,T,F,0,F,1					!CFORM,IFLAG,FMAG,FDEF,FASTIG,FPART,IEWALD,FBEAUT,FCREF,FMATCH,IFSC,FSTAT,IBLOW
${radius},0.0,${pix1},${AmpC},${mask},${pbc},0.0,10.,1,10	!RO,RI,PSIZE,WGH,XSTD,PBC,BOFF,DANG,ITMAX,IPMAX
1 1 1 1 1							!MASK
${first},${last}						!IFIRST,ILAST 
${sym}     							!ASYM symmetry card (I=icosahedral)
1.0,${dstep},60.0,${thresh1},2.0,${kV1},0.0,0.0			!RELMAG,DSTEP,TARGET,THRESH,CS,AKV,TX,TY
${rrec},200.0,${rref},100.0,${rbf} 				!RREC,RMAX1,RMAX2,DFSTD,RBFACT
${raw_images1}.mrc
/dev/null
${data_input}1_$start.par
${data_input}1.res
dummy1.shft
1.0,${dstep},90.0,${thresh2},2.0,${kV2},0.0,0.0			!RELMAG,DSTEP,TARGET,THRESH,CS,AKV,TX,TY
${rrec},200.0,${rref},100.0,${rbf}	 			!RREC,RMAX1,RMAX2,DFSTD,RBFACT
${raw_images2}.mrc
/dev/null
${data_input}2_$start.par
${data_input}2.res
dummy2.shft
1.0,${dstep},90.0,${thresh3},2.0,${kV3},0.0,0.0			!RELMAG,DSTEP,TARGET,THRESH,CS,AKV,TX,TY
${rrec},200.0,${rref},100.0,${rbf}				!RREC,RMAX1,RMAX2,DFSTD,RBFACT
${raw_images3}.mrc
/dev/null
${data_input}3_$start.par
${data_input}3.res
dummy3.shft
0., 0., 0., 0., 0., 0., 0., 0.					! terminator with RELMAG=0.0
${data_input}_$start.mrc
${data_input}_weights_$start
${data_input}_map1
${data_input}_map2
${data_input}_phasediffs
${data_input}_pointspread
eot
#
\rm dummy1.shft
\rm dummy2.shft
\rm dummy3.shft
#
date
