#!/bin/csh
#unlimit
limit coredumpsize 0
set working_directory = `pwd`
#
set start = 1
set target      = `grep thresh_refine mparameters_run | awk '{print $2}'`
set thresh      = `grep thresh_reconst mparameters_run | awk '{print $2}'`
set pbc         = `grep PBC mparameters_run | awk '{print $2}'`
set boff        = `grep BOFF mparameters_run | awk '{print $2}'`
set dang        = `grep DANG mparameters_run | awk '{print $2}'`
set itmax       = `grep ITMAX mparameters_run | awk '{print $2}'`
set mode        = `grep MODE mparameters_run | awk '{print $2}'`
set fpart       = `grep FPART mparameters_run | awk '{print $2}'`
set dfstd       = `grep DFSTD mparameters_run | awk '{print $2}'`
set rrec        = `grep res_reconstruction mparameters_run | awk '{print $2}'`
set rref        = `grep res_refinement mparameters_run | awk '{print $2}'`
set rlowref     = `grep res_low_refinement mparameters_run | awk '{print $2}'`
set data_input  = `grep data_input mparameters_run | awk '{print $2}'`
set raw_images1 = `grep raw_images1 mparameters_run | awk '{print $2}'`
set pixel_s     = `grep pixel_size mparameters_run | awk '{print $2}'`
set dstep       = `grep dstep mparameters_run | awk '{print $2}'`
set w_gh        = `grep WGH mparameters_run | awk '{print $2}'`
set kV1         = `grep kV1 mparameters_run | awk '{print $2}'`
set cs          = `grep Cs mparameters_run | awk '{print $2}'`
set xstd        = `grep XSTD mparameters_run | awk '{print $2}'`
set fmag        = `grep FMAG mparameters_run | awk '{print $2}'`
set fdef        = `grep FDEF mparameters_run | awk '{print $2}'`
set fastig      = `grep FASTIG mparameters_run | awk '{print $2}'`
set rbfact      = `grep RBFACT mparameters_run | awk '{print $2}'`
set iewald      = `grep IEWALD mparameters_run | awk '{print $2}'`
set asym        = `grep ASYM mparameters_run | awk '{print $2}'`
set FBEAUT      = `grep FBEAUT mparameters_run | awk '{print $2}'`
set FCREF       = `grep FCREF mparameters_run | awk '{print $2}'`
set ro          = `grep RO mparameters_run | awk '{print $2}'`
set ri          = `grep RI mparameters_run | awk '{print $2}'`

set SCRATCH = ${working_directory}

#
cd $SCRATCH
#
\rm ${data_input}_${start}.spi
\rm ${data_input}_${start}_weights
\rm ${data_input}_${start}_dummy.shft
\rm ${data_input}_${start}_phasediffs
\rm ${data_input}_${start}_pointspread
\rm ${data_input}_$start.res
cp -p ${working_directory}/${data_input}_$start.par ${data_input}_$start.par

time frealign_v8 << eot >& ${data_input}_mreconstruct_$start.log
S,0,${fmag},${fdef},${fastig},${fpart},${iewald},${FBEAUT},${FCREF},F,0,F,1	!CFORM,IFLAG,FMAG,FDEF,FASTIG,FPART,IEWALD,FBEAUT,FCREF,FMATCH,IFSC,FSTAT,IBLOW
${ro},${ri},${pixel_s},${w_gh},${xstd},${pbc},0.0,${dang},${itmax},10		!RO,RI,PSIZE,WGH,XSTD,PBC,BOFF,DANG,ITMAX,IPMAX
1 1 1 1 1									!MASK
1,1299										!IFIRST,ILAST 
${asym}										!ASYM symmetry card
-27.69231,9.54113,13,3,20							!ALPHA,RISE,#SUBUNITS,#STARTS,STIFFNESS
1., ${dstep}, ${target}, ${thresh}, ${cs}, ${kV1}, 0., 0.			!RELMAG,DSTEP,TARGET,THRESH,CS,AKV,TX,TY
${rrec}, ${rlowref},  ${rref}, ${dfstd}, ${rbfact}				!RREC,RMAX1,RMAX2,DFSTD,RBFACT
${working_directory}/${raw_images1}.spi
/dev/null
${data_input}_${start}.par
${data_input}_${start}.res
${data_input}_${start}_dummy.shft
0., 0., 0., 0., 0., 0., 0., 0.							!terminator with RELMAG=0.0
${data_input}_${start}.spi
${data_input}_${start}_weights
${data_input}_${start}_map1.spi
${data_input}_${start}_map2.spi
${data_input}_${start}_phasediffs
${data_input}_${start}_pointspread
eot
#
mv ${data_input}_${start}.spi ${working_directory}/.
\rm ${data_input}_${start}_weights
\rm ${data_input}_${start}_dummy.shft
#\rm ${data_input}_${start}_map1.spi
#\rm ${data_input}_${start}_map2.spi
\rm ${data_input}_${start}_phasediffs
\rm ${data_input}_${start}_pointspread
#
echo 'mreconstruct.com finished' >> ${data_input}_mreconstruct_$start.log
date
#
