#!/bin/sh
#
file=`echo $1 | cut -d. -f1`
ext=`echo $1 | cut -d. -f2`

# check if argument exists.
if [ ! -f $file.$ext ]; then
   echo "$file.$ext" does not exist!; exit 0
fi

# make sure the $script and $project are correct spelled!
if [ "`grep "script=" $file.$ext`" = "" ]; then
 	echo --- No SCRIPT defined in $file.$ext!; exit 0
fi

#
if [ "`grep "project=" $file.$ext`" = "" ]; then
	echo --- No PROJECT defined $file.$ext!; exit 0
fi


# get the line number of first contains ";"
breakline=`grep -n ";" $file.$ext | sed -n "1 p" | cut -d: -f1`
n=`expr $breakline - 1`

# shell part
echo "#!/bin/sh" > $file.sh
echo "" >> $file.sh
echo "# --- Don't modify this script, it is generated" >> $file.sh
echo "# --- automatically by running <mk.sh $file.$ext>." >> $file.sh
echo "# --- Modify $file.$ext instead." >> $file.sh
echo "" >> $file.sh
sed -n "1, $n p" $file.$ext >> $file.sh
#

# spider code part
echo ";;;;;;;;;;;;;;;;;;;;" >>tmp1
echo ";It is automatically generated by running <mk.sh $file.$ext>." >> tmp1
echo ";;;;;;;;;;;;;;;;;;;;" >>tmp1
sed -n "$breakline, $ p" $file.$ext >> tmp1

# add echo and >> for each line 
sed 's/^/echo "/' tmp1 > tmp2
echo 'touch $script.$project' > tmp3
sed 's/$/" >> $script.$project /' tmp2 > tmp
cat tmp3 tmp >> $file.sh 
#
rm -rf tmp tmp1 tmp2 tmp3
#
echo "" >> $file.sh

# delete previous version if it exist
project=`grep project= $file.$ext | cut -d'"' -f2`
script=`grep script= $file.$ext | cut -d'"' -f2`
if [ -f $script.$project ]; then
   rm -rf $script.$project
fi

# now run it
chmod +x $file.sh
./$file.sh
echo "Now ${script}.`echo $project` is available"

# and remove that after running
rm -rf $file.sh
