#! /bin/csh -f	
# C-shell script to generate multiple slave scripts with parameters from master script
# Performs CTF-correction using CTFTILT parameters
# Requires master, slave, spider.com
# Courtesy of Carsten Sachse and Niko Grigorieff, Brandeis University, Waltham, USA. 19-Apr-2007

set defgrps = 13    # number of defocus groups
set master = ctftilt-prep-master.amy        	# define master script
# number of lines that define variables in master script and pass them on to slave scripts
set no_lines = 42
set ctf_script = ctftilt-prep.amy			# define ctf-tilt script

tail -`wc -l $ctf_script |awk '{print $1-v1}' v1=$no_lines` $ctf_script > tmp022.src
 head -$no_lines $master > tmp024.src
 set n = 1
 while ( $n <= $defgrps )
   set num=`echo $n | awk '{printf("%03d",$1)}'`
        # produce spider script
        echo "X55=$n" > tmp021.src
        echo "X56=$defgrps" >> tmp021.src
        cat tmp024.src tmp021.src tmp022.src > $ctf_script:r$num.amy
        # generate c-shell spider start script for individual groups
        head -4 spider.com > tmp026.com
        echo "${PUBLIC}/SPIDER11.3.2/bin/spider_linux_mpfftw amy/dat @$ctf_script:r$num $num" > tmp027.com
        cat tmp026.com tmp027.com > $ctf_script:r$num.com
        chmod +x $ctf_script:r$num.com
    @ n = ($n + 1)
 end
 rm -f tmp*

