#!/usr/bin/env python
# Python script to convert boxer coordinates into SPIDER file format. 
# usage: box2spi.py infile outfile 
# Courtesy of Carsten Sachse and Niko Grigorieff, Brandeis University, Waltham, USA. 19-Apr-2007


# load system module:
import sys

# extract the 1st command-line argument:
try:
    infilename  = sys.argv[1]
    outfilename = sys.argv[2]
except:
    # try block failed,
    # we miss two command-line arguments
    print "Usage:", sys.argv[0], "infile outfile"
    sys.exit(1)

ifile = open( infilename, 'r')  # r for reading
ofile = open(outfilename, 'w')  # w for writing

nargs = len(sys.argv[1:])

if nargs == 0:
   print "Usage: box2spi.py box_file spi_file"
   sys.exit(0)
if nargs > 1:
   k=0

for line in ifile:
    pair = line.split()
    x = float(pair[0]); y = float(pair[1]); z = float(pair[2]); u = float(pair[3]); v = float(pair[4])
    k = k + 1
    n = 5
    ofile.write('%5d%2d%12.3f%12.3f%12.3f%12.3f%12.3f\n' % (k,n,x,y,z,u,v))

