#!/usr/bin/env python

# Python script to read output report from CTFTILT and to write defocus and astigmatism data to defocus 
# documentation file. 
# Usage: readtilt.py report [key_number]  > outdoc.dat 
# Provided by the SPIDER image processing system and modified by Carsten Sachse 19-Apr-2007
# --------------------------------------------------------------------------
# Read output report from MRC CTFTILT, print out defocus and other values for ctf-correction in spider.
#
# Usage: readtilt.py mrc_report outdoc 
#
# The micrograph number is obtained from the report filename (e.g., report003).
# The doc file key is either 1 for a nonexisting file or is appended to the existing file
# 
# 
# Output: 11 columns
#  key        mic no.  avg defocus  defocus1    defocus2   angle   tangle  cc  centerx   centery   N1(tiltaxis)  N2(tiltaxis)
#   13 6      13.000   26404.675   26446.720   26362.630   0.940   5.14   0.013     2720     3508      -0.477962      0.878381
# --------------------------------------------------------------------------

import sys
import string
import re
import os

re_filenum = re.compile('[0-9]+$')

def get_mic_number(s):
    a = string.rfind(s, '.')   # remove extension
    if a > -1:
        s = s[:a]
    m = re_filenum.search(s)
    b = m.span()
    i = string.atoi(s[b[0]:b[1]])
    return i

nargs = len(sys.argv[1:])

if nargs == 0:
    print "Usage: readmrc.py mrc_report [key] docfile"
    sys.exit(0)
if nargs > 0:
    report = sys.argv[1]
    mic = get_mic_number(report)
if nargs > 1:
    doc = sys.argv[2]
    try:
        about = os.stat(doc)
	exists = 1
    except OSError:
	exists = 0
    if exists == 1: 
       fc = open(doc)
       C = fc.readlines()
       fc.close

       key = len(C) + 1
    else: key = 1

else:
    key = mic

fp = open(report)
B = fp.readlines()
fp.close

for line in B:
    if string.find(line, "Final Values") > -1: break

s = string.split(line)
d1 = string.atof(s[0])
d2 = string.atof(s[1])
davg = (d1 + d2) / 2.0
angast = string.atof(s[2])
tangle = string.atof(s[4])
cc = string.atof(s[5])

for line in B:
    if string.find(line, "CENTER_X") > -1: break

s = string.split(line)
cenx = string.atof(s[4])

for line in B:
    if string.find(line, "CENTER_Y") > -1: break

s = string.split(line)
ceny = string.atof(s[4])

for line in B:
    if string.find(line, "-SIN(TLTAXIS)") > -1: break

s = string.split(line)
sint = string.atof(s[4])

for line in B:
    if string.find(line, "COS(TLTAXIS)") > -1: break

s = string.split(line)
cost = string.atof(s[4])

nitems = 11
print "%5d%3d%12.3f%12.3f%12.3f%12.3f%12.3f%12.3f%12.3f%12.3f%12.3f%12.3f%12.3f" % (key, nitems, mic, davg, d1, d2, angast, tangle, cc, cenx, ceny, sint, cost)
