#! /bin/csh -f	
# master mk.sh script that generates necessary subscripts for refinement
# Courtesy of Carsten Sachse and Niko Grigorieff, Brandeis University, Waltham, USA. 19-Apr-2007

# please have the following master scripts ready in the work directory
# subscripts are generated in the scr folder (com, src, amy extensions)
# 1. project.src
# 2. align.src
# 3. reconstr.src
# 4. impose-sym.src
# 5. polarity.src
# 6. spider.com

set master = prj-algn-rec-master.src        	# define master script
# number of header lines that define variables in master script and pass them on to slave scripts
set no_lines = 91

# projection
set project = project.src			# define projection script
set no_p = 49					# define number of projection scripts to be generated (corresponds to number of out-of-plane tilt dimensions)
# alignment
set align = align.src				# define alignment script
	# number of aligment scripts is the product of the no_hel_axis*algrps*defgrps !!
set no_hel_axis = 2				# set number of helical axis parameters
set algrps = 27    				# number of alignment groups
set defgrps = 13   				# number of defocus groups
# selection
set select = select.src
set no_s = 13
# reconstruction
set reconstr = reconstr.src			# define reconstruction script
set no_r = 9
# impose symmetry in 3D
set impose = impose-sym.src			# define impose symmetry script
set no_i = 26					# number of scripts 
set pol_script = polarity.src			# define polarity script

#############################################################################
#############################################################################
#############################################################################
#############################################################################

# make the first directories and define a few starting variables
mkdir prj
mkdir scr
set u = 1

#############################################################################
################################ 1.project.src ##############################
#############################################################################
set p = 1
while ( $p <= $no_p )
    # (1) generate list of project.src/project.amy files for defocus groups
    # copy $no_lines variables from master script into slave-scripts
    set pnam=`echo $p | awk '{printf("%03d",$1)}'`
    head -$no_lines $master > tmp002.src
    cat tmp002.src $project > tmp003.src
    tail -`wc -l tmp003.src |awk '{print $1-5}'` tmp003.src > tmp004.src
    echo "          script=scr/project$pnam" > tmp005.src
    echo '         project="amy"' >> tmp005.src
    echo '               #'>> tmp005.src
    echo '        work_dir="."' >> tmp005.src
    echo "          grp_no=$p" >> tmp005.src
    cat tmp005.src tmp004.src > scr/project$pnam.src
    rm -f scr/project$pnam.amy
    mk.sh scr/project$pnam.src 
    rm -f tmp00*
    
    # generate c-shell spider start script for individual groups
    head -4 spider.com > tmp026.com
    echo "${PUBLIC}/SPIDER11.3.2/bin/spider_linux_mpfftw amy/dat @scr/$project:r$pnam $pnam" > tmp027.com
    cat tmp026.com tmp027.com > scr/spider-prj$pnam.com
    chmod +x scr/spider-prj$pnam.com
    rm -f tmp02*
    @ p = ($p + 1)
end

 goto skip 
#######################################################################################
################################### 2.align.src #######################################
#######################################################################################

 set n = 1
 @ ual = $defgrps * $algrps
 @ inc = 360 / $no_hel_axis
 while ( $n <= $defgrps )
   
   set num=`echo $n | awk '{printf("%03d",$1)}'`
   mkdir grp$num
   # (3) generate spider and c-shell-scripts for alignment groups
       set k = 1
       while ( $k <= $algrps )
           set nam=`echo $k | awk '{printf("%03d",$1)}'`
           set j=$inc
           while ( $j <= 360 )
              set njm=`echo $j | awk '{printf("%03d",$1)}'`
              # copy $no_lines variables from master script into slave-scripts
              head -$no_lines $master > tmp012.src
              cat tmp012.src $align > tmp013.src
              # generate list of align-reconstr.src/align-reconstr.amy files for defocus groups
              tail -`wc -l tmp013.src |awk '{print $1-5}'` tmp013.src > tmp014.src
              echo "          script=scr/grp$num-al$nam-si$njm" > tmp015.src
              echo '         project="amy"' >> tmp015.src
              echo '               #'>> tmp015.src
              echo '        work_dir="."' >> tmp015.src
              echo "         grp_dir=grp$num/algrp$nam" >> tmp015.src
              echo "          grp_no=$n" >> tmp015.src
              echo "        algrp_no=$k" >> tmp015.src
              echo "       nrfr_side=$j" >> tmp015.src
              mkdir grp$num/algrp$nam
              cat tmp015.src tmp014.src > scr/align$nam.src
              rm -f scr/grp$num-al$nam-si$njm.amy
              mk.sh scr/align$nam.src 
              # generate c-shell spider start script for individual groups
              head -4 spider.com > tmp016.com
              echo "${PUBLIC}/SPIDER11.3.2/bin/spider_linux_mpfftw amy/dat @scr/grp$num-al$nam-si$njm $k$njm" > tmp017.com
              cat tmp016.com tmp017.com > scr/grp$num-al$nam-si$njm.com
              chmod +x scr/grp$num-al$nam-si$njm.com
              rm -f tmp01*
              @ j = ($j + $inc )
           end
           @ k = ($k + 1)
        end
        @ n = ($n + 1)
 end

 skip:
 goto skip1 
#######################################################################################
################################# 3.reconstr.src ######################################
#######################################################################################
set r = 1
while ( $r <= $no_r )
        # (2) generate list of reconstr.src/reconstr.amy files for defocus groups
        # copy $no_lines variables from master script into slave-scripts
        set nrm=`echo $r | awk '{printf("%03d",$1)}'`
        head -$no_lines $master > tmp102.src
        cat tmp102.src $reconstr > tmp103.src
        tail -`wc -l tmp103.src |awk '{print $1-5}'` tmp103.src > tmp104.src
        echo "          script=scr/reconstr$nrm" > tmp105.src
        echo '         project="amy"' >> tmp105.src
        echo '               #'>> tmp105.src
        echo '        work_dir="."' >> tmp105.src
        echo "         grp_dir=grp$nrm" >> tmp105.src
        echo "          grp_no=$r" >> tmp105.src
        cat tmp105.src tmp104.src > scr/reconstr$nrm.src
        rm -f scr/reconstr$nrm.amy
        mk.sh scr/reconstr$nrm.src 
        # generate c-shell spider start script for individual groups
        head -4 spider.com > tmp106.com
        echo "${PUBLIC}/SPIDER11.3.2/bin/spider_linux_mpfftw amy/dat @scr/reconstr$nrm $nrm" > tmp107.com
        cat tmp106.com tmp107.com > scr/spider-rec$nrm.com
        chmod +x scr/spider-rec$nrm.com
        rm -f tmp*
        @ r = ($r + 1)
end

#######################################################################################
############################### 4. impose-sym.src #####################################
#######################################################################################
set i = 1
while ( $i <= $no_i )
        # copy $no_lines variables from master script into slave-scripts
        set nim=`echo $i | awk '{printf("%03d",$1)}'`
        tail -`wc -l $impose |awk '{print $1-2}'` $impose > tmp022.src
        echo "X55=$i" > tmp021.src
        echo "X56=$no_i" >> tmp021.src
        cat tmp021.src tmp022.src > tmp023.src
        #
        head -$no_lines $master > tmp024.src
        tail -`wc -l tmp024.src |awk '{print $1-3}'` tmp024.src > tmp029.src
        cat tmp029.src tmp023.src > tmp025.src
        echo "          script=scr/impose-sym$nim" > tmp026.src
        echo '         project="amy"' >> tmp026.src
        echo '               #'>> tmp026.src
        cat tmp026.src tmp025.src >  scr/$impose:r$nim.src
        rm -f scr/$impose:r$nim.amy
        mk.sh scr/$impose:r$nim.src
        # generate c-shell spider start script for individual groups
        head -4 spider.com > tmp026.com
        echo "${PUBLIC}/SPIDER11.3.2/bin/spider_linux_mpfftw amy/dat @scr/$impose:r$nim $nim" > tmp027.com
        cat tmp026.com tmp027.com > scr/spider-imp$nim.com
        chmod +x scr/spider-imp$nim.com
        rm -f tmp02*
        @ i = ($i + 1)
end

 skip1:
#######################################################################################
############################### 5. polarity.src #####################################
#######################################################################################
        head -$no_lines $master > tmp024.src
        tail -`wc -l tmp024.src |awk '{print $1-3}'` tmp024.src > tmp029.src
        cat tmp029.src $pol_script > tmp025.src
        echo "          script=scr/polarity" > tmp026.src
        echo '         project="amy"' >> tmp026.src
        echo '               #'>> tmp026.src
        cat tmp026.src tmp025.src >  scr/$pol_script
        mk.sh scr/$pol_script
        rm -f tmp02*
