#include "core_headers.h"

SymmetryMatrix::SymmetryMatrix()
{
	rot_mat = NULL;
	number_of_matrices = 0;
//	MyPrintWithDetails("Error: Constructor must be called with symmetry symbol\n");
//	abort();
}

SymmetryMatrix::SymmetryMatrix(wxString wanted_symmetry_symbol)
{
	Init(wanted_symmetry_symbol);
}

void SymmetryMatrix::Init(wxString wanted_symmetry_symbol)
{
	wxChar   symmetry_type;
	long     symmetry_number;

	wanted_symmetry_symbol = wanted_symmetry_symbol.Trim();
	wanted_symmetry_symbol = wanted_symmetry_symbol.Trim(false);

	if (wanted_symmetry_symbol.Length() < 1)
	{
		MyPrintWithDetails("Error: Must specify symmetry symbol\n");
		abort();
	}
	symmetry_type = wanted_symmetry_symbol.Capitalize()[0];
	if (wanted_symmetry_symbol.Length() == 1)
	{
		symmetry_number = 0;
	}
	else
	{
		if (! wanted_symmetry_symbol.Mid(1).ToLong(&symmetry_number))
		{
			MyPrintWithDetails("Error: Invalid n after symmetry symbol: %s\n", wanted_symmetry_symbol.Mid(1));
			abort();
		}
	}

	symmetry_symbol = wanted_symmetry_symbol;

	if (symmetry_type == 'C')
	{
		int i;
		float angle;
		float delta_angle;

		if (symmetry_number == 0)
		{
			MyPrintWithDetails("Error: Invalid n after symmetry symbol\n");
			abort();
		}
		number_of_matrices = symmetry_number;
		if (rot_mat != NULL)
		{
			delete [] rot_mat;
		}
		rot_mat = new RotationMatrix[number_of_matrices];

//		wxPrintf("Initializing Cn symmetry matrices with n = %i\n",number_of_matrices);

		delta_angle = 2.0 * PI / number_of_matrices;
		for (i = 0; i < number_of_matrices; i++)
		{
			angle = i * delta_angle;
			rot_mat[i].SetToValues(cosf(angle), sinf(angle), 0.000000,-sinf(angle), cosf(angle), 0.000000, 0.000000, 0.000000, 1.000000);
		}

		return;
	}

	if (symmetry_type == 'D')
	{
		int i;
		float angle;
		float delta_angle;

		if (symmetry_number == 0)
		{
			MyPrintWithDetails("Error: Invalid n after symmetry symbol\n");
			abort();
		}
		number_of_matrices = symmetry_number;
		if (rot_mat != NULL)
		{
			delete [] rot_mat;
		}
		rot_mat = new RotationMatrix[2 * number_of_matrices];

//		wxPrintf("Initializing Dn symmetry matrices with n = %i\n",number_of_matrices);

		delta_angle = 2.0 * PI / number_of_matrices;
		for (i = 0; i < number_of_matrices; i++)
		{
			angle = i * delta_angle;
			rot_mat[i].SetToValues(cosf(angle), sinf(angle), 0.000000,-sinf(angle), cosf(angle), 0.000000, 0.000000, 0.000000, 1.000000);
			rot_mat[i + number_of_matrices].SetToValues(cosf(angle),-sinf(angle), 0.000000,-sinf(angle),-cosf(angle), 0.000000, 0.000000, 0.000000,-1.000000);
		}

		number_of_matrices = 2 * number_of_matrices;

		return;
	}

	if (symmetry_type == 'T')
	{
//		wxPrintf("Initializing T symmetry matrices...\n");

		number_of_matrices = 12;
		if (rot_mat != NULL)
		{
			delete [] rot_mat;
		}
		rot_mat = new RotationMatrix[number_of_matrices];

		if (symmetry_number < 2)
		{
			rot_mat[ 0].SetToValues( 1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000);
			rot_mat[ 1].SetToValues( 0.000000, 0.000000,-1.000000,-1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000);
			rot_mat[ 2].SetToValues( 0.000000,-1.000000, 0.000000, 0.000000, 0.000000,-1.000000, 1.000000, 0.000000, 0.000000);
			rot_mat[ 3].SetToValues(-1.000000, 0.000000, 0.000000, 0.000000,-1.000000, 0.000000, 0.000000, 0.000000, 1.000000);
			rot_mat[ 4].SetToValues( 0.000000, 0.000000,-1.000000, 1.000000, 0.000000, 0.000000, 0.000000,-1.000000, 0.000000);
			rot_mat[ 5].SetToValues( 0.000000,-1.000000, 0.000000, 0.000000, 0.000000, 1.000000,-1.000000, 0.000000, 0.000000);
			rot_mat[ 6].SetToValues(-1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000,-1.000000);
			rot_mat[ 7].SetToValues( 0.000000, 0.000000, 1.000000,-1.000000, 0.000000, 0.000000, 0.000000,-1.000000, 0.000000);
			rot_mat[ 8].SetToValues( 0.000000, 1.000000, 0.000000, 0.000000, 0.000000,-1.000000,-1.000000, 0.000000, 0.000000);
			rot_mat[ 9].SetToValues( 1.000000, 0.000000, 0.000000, 0.000000,-1.000000, 0.000000, 0.000000, 0.000000,-1.000000);
			rot_mat[10].SetToValues( 0.000000, 0.000000, 1.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000);
			rot_mat[11].SetToValues( 0.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 1.000000, 0.000000, 0.000000);

	/*		rot_mat[ 0].SetToValues( 1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000);
			rot_mat[ 1].SetToValues( 0.000000,-1.000000, 0.000000, 0.000000, 0.000000, 1.000000,-1.000000, 0.000000, 0.000000);
			rot_mat[ 2].SetToValues( 0.000000, 0.000000, 1.000000,-1.000000, 0.000000, 0.000000, 0.000000,-1.000000, 0.000000);
			rot_mat[ 3].SetToValues(-1.000000, 0.000000, 0.000000, 0.000000,-1.000000, 0.000000, 0.000000, 0.000000, 1.000000);
			rot_mat[ 4].SetToValues( 0.000000, 1.000000, 0.000000, 0.000000, 0.000000,-1.000000,-1.000000, 0.000000, 0.000000);
			rot_mat[ 5].SetToValues( 0.000000, 0.000000,-1.000000,-1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000);
			rot_mat[ 6].SetToValues(-1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000,-1.000000);
			rot_mat[ 7].SetToValues( 0.000000,-1.000000, 0.000000, 0.000000, 0.000000,-1.000000, 1.000000, 0.000000, 0.000000);
			rot_mat[ 8].SetToValues( 0.000000, 0.000000,-1.000000, 1.000000, 0.000000, 0.000000, 0.000000,-1.000000, 0.000000);
			rot_mat[ 9].SetToValues( 1.000000, 0.000000, 0.000000, 0.000000,-1.000000, 0.000000, 0.000000, 0.000000,-1.000000);
			rot_mat[10].SetToValues( 0.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 1.000000, 0.000000, 0.000000);
			rot_mat[11].SetToValues( 0.000000, 0.000000, 1.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000);
	*/
			return;
		}

		// Use octahedral conventions according to Relion.
		if (symmetry_number == 2)
		{
			rot_mat[ 0].SetToValues( 1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000);
			rot_mat[ 1].SetToValues(-0.500005,-0.288678,-0.816495, 0.288671, 0.833331,-0.471411, 0.816493,-0.471410,-0.333332);
			rot_mat[ 2].SetToValues( 0.500005,-0.288678,-0.816495,-0.866021,-0.166669,-0.471411, 0.000007, 0.942809,-0.333332);
			rot_mat[ 3].SetToValues( 0.000000, 0.577356,-0.816495, 0.577350,-0.666662,-0.471411,-0.816500,-0.471399,-0.333332);
			rot_mat[ 4].SetToValues( 0.500000, 0.288675, 0.816500, 0.866028,-0.166665,-0.471400,-0.000006, 0.942810,-0.333330);
			rot_mat[ 5].SetToValues(-0.500000, 0.288675, 0.816500,-0.288678, 0.833335,-0.471400,-0.816494,-0.471410,-0.333330);
			rot_mat[ 6].SetToValues( 0.000000,-0.577350, 0.816500,-0.577350,-0.666670,-0.471400, 0.816500,-0.471400,-0.333330);
			rot_mat[ 7].SetToValues( 0.500000,-0.866025, 0.000000,-0.288672,-0.166665, 0.942810,-0.816497,-0.471405,-0.333330);
			rot_mat[ 8].SetToValues( 0.500000, 0.866025, 0.000000, 0.288672,-0.166665, 0.942810, 0.816497,-0.471405,-0.333330);
			rot_mat[ 9].SetToValues(-1.000000, 0.000000, 0.000000, 0.000000, 0.333330, 0.942810, 0.000000, 0.942810,-0.333330);
			rot_mat[10].SetToValues(-0.500000, 0.866025, 0.000000,-0.866025,-0.500000, 0.000000, 0.000000, 0.000000, 1.000000);
			rot_mat[11].SetToValues(-0.500000,-0.866025, 0.000000, 0.866025,-0.500000, 0.000000, 0.000000, 0.000000, 1.000000);

			return;
		}
	}

	if (symmetry_type == 'O')
	{
//		wxPrintf("Initializing O symmetry matrices...\n");

		number_of_matrices = 24;
		if (rot_mat != NULL)
		{
			delete [] rot_mat;
		}
		rot_mat = new RotationMatrix[number_of_matrices];

		rot_mat[ 0].SetToValues( 1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000);
		rot_mat[ 1].SetToValues( 0.000000, 0.000000,-1.000000,-1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000);
		rot_mat[ 2].SetToValues( 0.000000, 0.000000,-1.000000, 0.000000,-1.000000, 0.000000,-1.000000, 0.000000, 0.000000);
		rot_mat[ 3].SetToValues( 0.000000, 0.000000,-1.000000, 1.000000, 0.000000, 0.000000, 0.000000,-1.000000, 0.000000);
		rot_mat[ 4].SetToValues( 0.000000, 0.000000,-1.000000, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000, 0.000000);
		rot_mat[ 5].SetToValues( 0.000000, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000,-1.000000, 0.000000, 0.000000);
		rot_mat[ 6].SetToValues( 0.000000, 0.000000, 1.000000,-1.000000, 0.000000, 0.000000, 0.000000,-1.000000, 0.000000);
		rot_mat[ 7].SetToValues( 0.000000, 0.000000, 1.000000, 0.000000,-1.000000, 0.000000, 1.000000, 0.000000, 0.000000);
		rot_mat[ 8].SetToValues( 0.000000, 0.000000, 1.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000);
		rot_mat[ 9].SetToValues( 0.000000, 1.000000, 0.000000, 0.000000, 0.000000,-1.000000,-1.000000, 0.000000, 0.000000);
		rot_mat[10].SetToValues(-1.000000, 0.000000, 0.000000, 0.000000, 0.000000,-1.000000, 0.000000,-1.000000, 0.000000);
		rot_mat[11].SetToValues( 0.000000,-1.000000, 0.000000, 0.000000, 0.000000,-1.000000, 1.000000, 0.000000, 0.000000);
		rot_mat[12].SetToValues( 1.000000, 0.000000, 0.000000, 0.000000, 0.000000,-1.000000, 0.000000, 1.000000, 0.000000);
		rot_mat[13].SetToValues(-1.000000, 0.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000);
		rot_mat[14].SetToValues( 0.000000,-1.000000, 0.000000, 0.000000, 0.000000, 1.000000,-1.000000, 0.000000, 0.000000);
		rot_mat[15].SetToValues( 1.000000, 0.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000,-1.000000, 0.000000);
		rot_mat[16].SetToValues( 0.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 1.000000, 0.000000, 0.000000);
		rot_mat[17].SetToValues(-1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000,-1.000000);
		rot_mat[18].SetToValues( 0.000000,-1.000000, 0.000000,-1.000000, 0.000000, 0.000000, 0.000000, 0.000000,-1.000000);
		rot_mat[19].SetToValues( 1.000000, 0.000000, 0.000000, 0.000000,-1.000000, 0.000000, 0.000000, 0.000000,-1.000000);
		rot_mat[20].SetToValues( 0.000000, 1.000000, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000, 0.000000,-1.000000);
		rot_mat[21].SetToValues( 0.000000, 1.000000, 0.000000,-1.000000, 0.000000, 0.000000, 0.000000, 0.000000, 1.000000);
		rot_mat[22].SetToValues(-1.000000, 0.000000, 0.000000, 0.000000,-1.000000, 0.000000, 0.000000, 0.000000, 1.000000);
		rot_mat[23].SetToValues( 0.000000,-1.000000, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000, 0.000000, 1.000000);

/*		rot_mat[ 0].SetToValues( 1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000);
		rot_mat[ 1].SetToValues( 0.000000,-1.000000, 0.000000, 0.000000, 0.000000, 1.000000,-1.000000, 0.000000, 0.000000);
		rot_mat[ 2].SetToValues( 0.000000, 0.000000,-1.000000, 0.000000,-1.000000, 0.000000,-1.000000, 0.000000, 0.000000);
		rot_mat[ 3].SetToValues( 0.000000, 1.000000, 0.000000, 0.000000, 0.000000,-1.000000,-1.000000, 0.000000, 0.000000);
		rot_mat[ 4].SetToValues( 0.000000, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000,-1.000000, 0.000000, 0.000000);
		rot_mat[ 5].SetToValues( 0.000000, 0.000000,-1.000000, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000, 0.000000);
		rot_mat[ 6].SetToValues( 0.000000,-1.000000, 0.000000, 0.000000, 0.000000,-1.000000, 1.000000, 0.000000, 0.000000);
		rot_mat[ 7].SetToValues( 0.000000, 0.000000, 1.000000, 0.000000,-1.000000, 0.000000, 1.000000, 0.000000, 0.000000);
		rot_mat[ 8].SetToValues( 0.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 1.000000, 0.000000, 0.000000);
		rot_mat[ 9].SetToValues( 0.000000, 0.000000,-1.000000, 1.000000, 0.000000, 0.000000, 0.000000,-1.000000, 0.000000);
		rot_mat[10].SetToValues(-1.000000, 0.000000, 0.000000, 0.000000, 0.000000,-1.000000, 0.000000,-1.000000, 0.000000);
		rot_mat[11].SetToValues( 0.000000, 0.000000, 1.000000,-1.000000, 0.000000, 0.000000, 0.000000,-1.000000, 0.000000);
		rot_mat[12].SetToValues( 1.000000, 0.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000,-1.000000, 0.000000);
		rot_mat[13].SetToValues(-1.000000, 0.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000);
		rot_mat[14].SetToValues( 0.000000, 0.000000,-1.000000,-1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000);
		rot_mat[15].SetToValues( 1.000000, 0.000000, 0.000000, 0.000000, 0.000000,-1.000000, 0.000000, 1.000000, 0.000000);
		rot_mat[16].SetToValues( 0.000000, 0.000000, 1.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000);
		rot_mat[17].SetToValues(-1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000,-1.000000);
		rot_mat[18].SetToValues( 0.000000,-1.000000, 0.000000,-1.000000, 0.000000, 0.000000, 0.000000, 0.000000,-1.000000);
		rot_mat[19].SetToValues( 1.000000, 0.000000, 0.000000, 0.000000,-1.000000, 0.000000, 0.000000, 0.000000,-1.000000);
		rot_mat[20].SetToValues( 0.000000, 1.000000, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000, 0.000000,-1.000000);
		rot_mat[21].SetToValues( 0.000000,-1.000000, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000, 0.000000, 1.000000);
		rot_mat[22].SetToValues(-1.000000, 0.000000, 0.000000, 0.000000,-1.000000, 0.000000, 0.000000, 0.000000, 1.000000);
		rot_mat[23].SetToValues( 0.000000, 1.000000, 0.000000,-1.000000, 0.000000, 0.000000, 0.000000, 0.000000, 1.000000);
*/
		return;
	}

	if (symmetry_type == 'I')
	{
//		wxPrintf("Initializing I symmetry matrices...\n");

		number_of_matrices = 60;
		if (rot_mat != NULL)
		{
			delete [] rot_mat;
		}
		rot_mat = new RotationMatrix[number_of_matrices];

		if (symmetry_number < 2)
		{
			rot_mat[ 0].SetToValues( 1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000);
			rot_mat[ 1].SetToValues(-0.500000,-0.309017,-0.809017,-0.309017,-0.809017, 0.500000,-0.809017, 0.500000, 0.309017);
			rot_mat[ 2].SetToValues(-0.309017,-0.809017,-0.500000, 0.809017,-0.500000, 0.309017,-0.500000,-0.309017, 0.809017);
			rot_mat[ 3].SetToValues( 0.309017,-0.809017,-0.500000, 0.809017, 0.500000,-0.309017, 0.500000,-0.309017, 0.809017);
			rot_mat[ 4].SetToValues( 0.500000,-0.309017,-0.809017,-0.309017, 0.809017,-0.500000, 0.809017, 0.500000, 0.309017);
			rot_mat[ 5].SetToValues( 0.000000, 0.000000,-1.000000,-1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000);
			rot_mat[ 6].SetToValues( 0.809017,-0.500000,-0.309017,-0.500000,-0.309017,-0.809017, 0.309017, 0.809017,-0.500000);
			rot_mat[ 7].SetToValues( 0.500000, 0.309017,-0.809017,-0.309017,-0.809017,-0.500000,-0.809017, 0.500000,-0.309017);
			rot_mat[ 8].SetToValues(-0.500000, 0.309017,-0.809017, 0.309017,-0.809017,-0.500000,-0.809017,-0.500000, 0.309017);
			rot_mat[ 9].SetToValues(-0.809017,-0.500000,-0.309017, 0.500000,-0.309017,-0.809017, 0.309017,-0.809017, 0.500000);
			rot_mat[10].SetToValues( 0.000000,-1.000000, 0.000000, 0.000000, 0.000000,-1.000000, 1.000000, 0.000000, 0.000000);
			rot_mat[11].SetToValues(-0.309017,-0.809017, 0.500000, 0.809017,-0.500000,-0.309017, 0.500000, 0.309017, 0.809017);
			rot_mat[12].SetToValues( 0.809017,-0.500000, 0.309017, 0.500000, 0.309017,-0.809017, 0.309017, 0.809017, 0.500000);
			rot_mat[13].SetToValues( 0.809017, 0.500000,-0.309017,-0.500000, 0.309017,-0.809017,-0.309017, 0.809017, 0.500000);
			rot_mat[14].SetToValues(-0.309017, 0.809017,-0.500000,-0.809017,-0.500000,-0.309017,-0.500000, 0.309017, 0.809017);
			rot_mat[15].SetToValues(-1.000000, 0.000000, 0.000000, 0.000000,-1.000000, 0.000000, 0.000000, 0.000000, 1.000000);
			rot_mat[16].SetToValues(-0.500000,-0.309017,-0.809017, 0.309017, 0.809017,-0.500000, 0.809017,-0.500000,-0.309017);
			rot_mat[17].SetToValues(-0.309017,-0.809017,-0.500000,-0.809017, 0.500000,-0.309017, 0.500000, 0.309017,-0.809017);
			rot_mat[18].SetToValues( 0.309017,-0.809017,-0.500000,-0.809017,-0.500000, 0.309017,-0.500000, 0.309017,-0.809017);
			rot_mat[19].SetToValues( 0.500000,-0.309017,-0.809017, 0.309017,-0.809017, 0.500000,-0.809017,-0.500000,-0.309017);
			rot_mat[20].SetToValues( 0.000000, 0.000000,-1.000000, 1.000000, 0.000000, 0.000000, 0.000000,-1.000000, 0.000000);
			rot_mat[21].SetToValues( 0.809017,-0.500000,-0.309017, 0.500000, 0.309017, 0.809017,-0.309017,-0.809017, 0.500000);
			rot_mat[22].SetToValues( 0.500000, 0.309017,-0.809017, 0.309017, 0.809017, 0.500000, 0.809017,-0.500000, 0.309017);
			rot_mat[23].SetToValues(-0.500000, 0.309017,-0.809017,-0.309017, 0.809017, 0.500000, 0.809017, 0.500000,-0.309017);
			rot_mat[24].SetToValues(-0.809017,-0.500000,-0.309017,-0.500000, 0.309017, 0.809017,-0.309017, 0.809017,-0.500000);
			rot_mat[25].SetToValues( 0.000000,-1.000000, 0.000000, 0.000000, 0.000000, 1.000000,-1.000000, 0.000000, 0.000000);
			rot_mat[26].SetToValues(-0.309017,-0.809017, 0.500000,-0.809017, 0.500000, 0.309017,-0.500000,-0.309017,-0.809017);
			rot_mat[27].SetToValues( 0.809017,-0.500000, 0.309017,-0.500000,-0.309017, 0.809017,-0.309017,-0.809017,-0.500000);
			rot_mat[28].SetToValues( 0.809017, 0.500000,-0.309017, 0.500000,-0.309017, 0.809017, 0.309017,-0.809017,-0.500000);
			rot_mat[29].SetToValues(-0.309017, 0.809017,-0.500000, 0.809017, 0.500000, 0.309017, 0.500000,-0.309017,-0.809017);
			rot_mat[30].SetToValues(-1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000,-1.000000);
			rot_mat[31].SetToValues( 0.500000, 0.309017, 0.809017,-0.309017,-0.809017, 0.500000, 0.809017,-0.500000,-0.309017);
			rot_mat[32].SetToValues( 0.309017, 0.809017, 0.500000, 0.809017,-0.500000, 0.309017, 0.500000, 0.309017,-0.809017);
			rot_mat[33].SetToValues(-0.309017, 0.809017, 0.500000, 0.809017, 0.500000,-0.309017,-0.500000, 0.309017,-0.809017);
			rot_mat[34].SetToValues(-0.500000, 0.309017, 0.809017,-0.309017, 0.809017,-0.500000,-0.809017,-0.500000,-0.309017);
			rot_mat[35].SetToValues( 0.000000, 0.000000, 1.000000,-1.000000, 0.000000, 0.000000, 0.000000,-1.000000, 0.000000);
			rot_mat[36].SetToValues(-0.809017, 0.500000, 0.309017,-0.500000,-0.309017,-0.809017,-0.309017,-0.809017, 0.500000);
			rot_mat[37].SetToValues(-0.500000,-0.309017, 0.809017,-0.309017,-0.809017,-0.500000, 0.809017,-0.500000, 0.309017);
			rot_mat[38].SetToValues( 0.500000,-0.309017, 0.809017, 0.309017,-0.809017,-0.500000, 0.809017, 0.500000,-0.309017);
			rot_mat[39].SetToValues( 0.809017, 0.500000, 0.309017, 0.500000,-0.309017,-0.809017,-0.309017, 0.809017,-0.500000);
			rot_mat[40].SetToValues( 0.000000, 1.000000, 0.000000, 0.000000, 0.000000,-1.000000,-1.000000, 0.000000, 0.000000);
			rot_mat[41].SetToValues( 0.309017, 0.809017,-0.500000, 0.809017,-0.500000,-0.309017,-0.500000,-0.309017,-0.809017);
			rot_mat[42].SetToValues(-0.809017, 0.500000,-0.309017, 0.500000, 0.309017,-0.809017,-0.309017,-0.809017,-0.500000);
			rot_mat[43].SetToValues(-0.809017,-0.500000, 0.309017,-0.500000, 0.309017,-0.809017, 0.309017,-0.809017,-0.500000);
			rot_mat[44].SetToValues( 0.309017,-0.809017, 0.500000,-0.809017,-0.500000,-0.309017, 0.500000,-0.309017,-0.809017);
			rot_mat[45].SetToValues( 1.000000, 0.000000, 0.000000, 0.000000,-1.000000, 0.000000, 0.000000, 0.000000,-1.000000);
			rot_mat[46].SetToValues( 0.500000, 0.309017, 0.809017, 0.309017, 0.809017,-0.500000,-0.809017, 0.500000, 0.309017);
			rot_mat[47].SetToValues( 0.309017, 0.809017, 0.500000,-0.809017, 0.500000,-0.309017,-0.500000,-0.309017, 0.809017);
			rot_mat[48].SetToValues(-0.309017, 0.809017, 0.500000,-0.809017,-0.500000, 0.309017, 0.500000,-0.309017, 0.809017);
			rot_mat[49].SetToValues(-0.500000, 0.309017, 0.809017, 0.309017,-0.809017, 0.500000, 0.809017, 0.500000, 0.309017);
			rot_mat[50].SetToValues( 0.000000, 0.000000, 1.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000);
			rot_mat[51].SetToValues(-0.809017, 0.500000, 0.309017, 0.500000, 0.309017, 0.809017, 0.309017, 0.809017,-0.500000);
			rot_mat[52].SetToValues(-0.500000,-0.309017, 0.809017, 0.309017, 0.809017, 0.500000,-0.809017, 0.500000,-0.309017);
			rot_mat[53].SetToValues( 0.500000,-0.309017, 0.809017,-0.309017, 0.809017, 0.500000,-0.809017,-0.500000, 0.309017);
			rot_mat[54].SetToValues( 0.809017, 0.500000, 0.309017,-0.500000, 0.309017, 0.809017, 0.309017,-0.809017, 0.500000);
			rot_mat[55].SetToValues( 0.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 1.000000, 0.000000, 0.000000);
			rot_mat[56].SetToValues( 0.309017, 0.809017,-0.500000,-0.809017, 0.500000, 0.309017, 0.500000, 0.309017, 0.809017);
			rot_mat[57].SetToValues(-0.809017, 0.500000,-0.309017,-0.500000,-0.309017, 0.809017, 0.309017, 0.809017, 0.500000);
			rot_mat[58].SetToValues(-0.809017,-0.500000, 0.309017, 0.500000,-0.309017, 0.809017,-0.309017, 0.809017, 0.500000);
			rot_mat[59].SetToValues( 0.309017,-0.809017, 0.500000, 0.809017, 0.500000, 0.309017,-0.500000, 0.309017, 0.809017);

/*			rot_mat[ 0].SetToValues( 1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000);
			rot_mat[ 1].SetToValues(-0.500000,-0.309017,-0.809017,-0.309017,-0.809017, 0.500000,-0.809017, 0.500000, 0.309017);
			rot_mat[ 2].SetToValues(-0.309017, 0.809017,-0.500000,-0.809017,-0.500000,-0.309017,-0.500000, 0.309017, 0.809017);
			rot_mat[ 3].SetToValues( 0.309017, 0.809017, 0.500000,-0.809017, 0.500000,-0.309017,-0.500000,-0.309017, 0.809017);
			rot_mat[ 4].SetToValues( 0.500000,-0.309017, 0.809017,-0.309017, 0.809017, 0.500000,-0.809017,-0.500000, 0.309017);
			rot_mat[ 5].SetToValues( 0.000000,-1.000000, 0.000000, 0.000000, 0.000000, 1.000000,-1.000000, 0.000000, 0.000000);
			rot_mat[ 6].SetToValues( 0.809017,-0.500000, 0.309017,-0.500000,-0.309017, 0.809017,-0.309017,-0.809017,-0.500000);
			rot_mat[ 7].SetToValues( 0.500000,-0.309017,-0.809017, 0.309017,-0.809017, 0.500000,-0.809017,-0.500000,-0.309017);
			rot_mat[ 8].SetToValues(-0.500000, 0.309017,-0.809017, 0.309017,-0.809017,-0.500000,-0.809017,-0.500000, 0.309017);
			rot_mat[ 9].SetToValues(-0.809017, 0.500000, 0.309017,-0.500000,-0.309017,-0.809017,-0.309017,-0.809017, 0.500000);
			rot_mat[10].SetToValues( 0.000000, 0.000000, 1.000000,-1.000000, 0.000000, 0.000000, 0.000000,-1.000000, 0.000000);
			rot_mat[11].SetToValues(-0.309017, 0.809017, 0.500000,-0.809017,-0.500000, 0.309017, 0.500000,-0.309017, 0.809017);
			rot_mat[12].SetToValues( 0.809017, 0.500000, 0.309017,-0.500000, 0.309017, 0.809017, 0.309017,-0.809017, 0.500000);
			rot_mat[13].SetToValues( 0.809017,-0.500000,-0.309017, 0.500000, 0.309017, 0.809017,-0.309017,-0.809017, 0.500000);
			rot_mat[14].SetToValues(-0.309017,-0.809017,-0.500000, 0.809017,-0.500000, 0.309017,-0.500000,-0.309017, 0.809017);
			rot_mat[15].SetToValues(-1.000000, 0.000000, 0.000000, 0.000000,-1.000000, 0.000000, 0.000000, 0.000000, 1.000000);
			rot_mat[16].SetToValues(-0.500000, 0.309017, 0.809017,-0.309017, 0.809017,-0.500000,-0.809017,-0.500000,-0.309017);
			rot_mat[17].SetToValues(-0.309017,-0.809017, 0.500000,-0.809017, 0.500000, 0.309017,-0.500000,-0.309017,-0.809017);
			rot_mat[18].SetToValues( 0.309017,-0.809017,-0.500000,-0.809017,-0.500000, 0.309017,-0.500000, 0.309017,-0.809017);
			rot_mat[19].SetToValues( 0.500000, 0.309017,-0.809017,-0.309017,-0.809017,-0.500000,-0.809017, 0.500000,-0.309017);
			rot_mat[20].SetToValues( 0.000000, 1.000000, 0.000000, 0.000000, 0.000000,-1.000000,-1.000000, 0.000000, 0.000000);
			rot_mat[21].SetToValues( 0.809017, 0.500000,-0.309017,-0.500000, 0.309017,-0.809017,-0.309017, 0.809017, 0.500000);
			rot_mat[22].SetToValues( 0.500000, 0.309017, 0.809017, 0.309017, 0.809017,-0.500000,-0.809017, 0.500000, 0.309017);
			rot_mat[23].SetToValues(-0.500000,-0.309017, 0.809017, 0.309017, 0.809017, 0.500000,-0.809017, 0.500000,-0.309017);
			rot_mat[24].SetToValues(-0.809017,-0.500000,-0.309017,-0.500000, 0.309017, 0.809017,-0.309017, 0.809017,-0.500000);
			rot_mat[25].SetToValues( 0.000000, 0.000000,-1.000000,-1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000);
			rot_mat[26].SetToValues(-0.309017,-0.809017,-0.500000,-0.809017, 0.500000,-0.309017, 0.500000, 0.309017,-0.809017);
			rot_mat[27].SetToValues( 0.809017,-0.500000,-0.309017,-0.500000,-0.309017,-0.809017, 0.309017, 0.809017,-0.500000);
			rot_mat[28].SetToValues( 0.809017, 0.500000, 0.309017, 0.500000,-0.309017,-0.809017,-0.309017, 0.809017,-0.500000);
			rot_mat[29].SetToValues(-0.309017, 0.809017, 0.500000, 0.809017, 0.500000,-0.309017,-0.500000, 0.309017,-0.809017);
			rot_mat[30].SetToValues(-1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000,-1.000000);
			rot_mat[31].SetToValues( 0.500000,-0.309017, 0.809017, 0.309017,-0.809017,-0.500000, 0.809017, 0.500000,-0.309017);
			rot_mat[32].SetToValues( 0.309017, 0.809017, 0.500000, 0.809017,-0.500000, 0.309017, 0.500000, 0.309017,-0.809017);
			rot_mat[33].SetToValues(-0.309017, 0.809017,-0.500000, 0.809017, 0.500000, 0.309017, 0.500000,-0.309017,-0.809017);
			rot_mat[34].SetToValues(-0.500000,-0.309017,-0.809017, 0.309017, 0.809017,-0.500000, 0.809017,-0.500000,-0.309017);
			rot_mat[35].SetToValues( 0.000000,-1.000000, 0.000000, 0.000000, 0.000000,-1.000000, 1.000000, 0.000000, 0.000000);
			rot_mat[36].SetToValues(-0.809017,-0.500000,-0.309017, 0.500000,-0.309017,-0.809017, 0.309017,-0.809017, 0.500000);
			rot_mat[37].SetToValues(-0.500000,-0.309017, 0.809017,-0.309017,-0.809017,-0.500000, 0.809017,-0.500000, 0.309017);
			rot_mat[38].SetToValues( 0.500000, 0.309017, 0.809017,-0.309017,-0.809017, 0.500000, 0.809017,-0.500000,-0.309017);
			rot_mat[39].SetToValues( 0.809017, 0.500000,-0.309017, 0.500000,-0.309017, 0.809017, 0.309017,-0.809017,-0.500000);
			rot_mat[40].SetToValues( 0.000000, 0.000000,-1.000000, 1.000000, 0.000000, 0.000000, 0.000000,-1.000000, 0.000000);
			rot_mat[41].SetToValues( 0.309017, 0.809017,-0.500000, 0.809017,-0.500000,-0.309017,-0.500000,-0.309017,-0.809017);
			rot_mat[42].SetToValues(-0.809017, 0.500000,-0.309017, 0.500000, 0.309017,-0.809017,-0.309017,-0.809017,-0.500000);
			rot_mat[43].SetToValues(-0.809017,-0.500000, 0.309017,-0.500000, 0.309017,-0.809017, 0.309017,-0.809017,-0.500000);
			rot_mat[44].SetToValues( 0.309017,-0.809017, 0.500000,-0.809017,-0.500000,-0.309017, 0.500000,-0.309017,-0.809017);
			rot_mat[45].SetToValues( 1.000000, 0.000000, 0.000000, 0.000000,-1.000000, 0.000000, 0.000000, 0.000000,-1.000000);
			rot_mat[46].SetToValues( 0.500000, 0.309017,-0.809017, 0.309017, 0.809017, 0.500000, 0.809017,-0.500000, 0.309017);
			rot_mat[47].SetToValues( 0.309017,-0.809017,-0.500000, 0.809017, 0.500000,-0.309017, 0.500000,-0.309017, 0.809017);
			rot_mat[48].SetToValues(-0.309017,-0.809017, 0.500000, 0.809017,-0.500000,-0.309017, 0.500000, 0.309017, 0.809017);
			rot_mat[49].SetToValues(-0.500000, 0.309017, 0.809017, 0.309017,-0.809017, 0.500000, 0.809017, 0.500000, 0.309017);
			rot_mat[50].SetToValues( 0.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 1.000000, 0.000000, 0.000000);
			rot_mat[51].SetToValues(-0.809017, 0.500000, 0.309017, 0.500000, 0.309017, 0.809017, 0.309017, 0.809017,-0.500000);
			rot_mat[52].SetToValues(-0.500000, 0.309017,-0.809017,-0.309017, 0.809017, 0.500000, 0.809017, 0.500000,-0.309017);
			rot_mat[53].SetToValues( 0.500000,-0.309017,-0.809017,-0.309017, 0.809017,-0.500000, 0.809017, 0.500000, 0.309017);
			rot_mat[54].SetToValues( 0.809017,-0.500000, 0.309017, 0.500000, 0.309017,-0.809017, 0.309017, 0.809017, 0.500000);
			rot_mat[55].SetToValues( 0.000000, 0.000000, 1.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000);
			rot_mat[56].SetToValues( 0.309017,-0.809017, 0.500000, 0.809017, 0.500000, 0.309017,-0.500000, 0.309017, 0.809017);
			rot_mat[57].SetToValues(-0.809017,-0.500000, 0.309017, 0.500000,-0.309017, 0.809017,-0.309017, 0.809017, 0.500000);
			rot_mat[58].SetToValues(-0.809017, 0.500000,-0.309017,-0.500000,-0.309017, 0.809017, 0.309017, 0.809017, 0.500000);
			rot_mat[59].SetToValues( 0.309017, 0.809017,-0.500000,-0.809017, 0.500000, 0.309017, 0.500000, 0.309017, 0.809017);
*/
			return;
		}

		// Use icosahedral conventions according to Crowther et al.
		if (symmetry_number == 2)
		{
			rot_mat[ 0].SetToValues( 1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000);
			rot_mat[ 1].SetToValues( 0.500000,-0.809017,-0.309017,-0.809017,-0.309017,-0.500000, 0.309017, 0.500000,-0.809017);
			rot_mat[ 2].SetToValues( 0.309017,-0.500000, 0.809017,-0.500000,-0.809017,-0.309017, 0.809017,-0.309017,-0.500000);
			rot_mat[ 3].SetToValues(-0.309017, 0.500000, 0.809017,-0.500000,-0.809017, 0.309017, 0.809017,-0.309017, 0.500000);
			rot_mat[ 4].SetToValues(-0.500000, 0.809017,-0.309017,-0.809017,-0.309017, 0.500000, 0.309017, 0.500000, 0.809017);
			rot_mat[ 5].SetToValues( 0.000000, 0.000000,-1.000000,-1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000);
			rot_mat[ 6].SetToValues(-0.309017,-0.500000, 0.809017, 0.500000,-0.809017,-0.309017, 0.809017, 0.309017, 0.500000);
			rot_mat[ 7].SetToValues(-0.809017, 0.309017, 0.500000, 0.309017,-0.500000, 0.809017, 0.500000, 0.809017, 0.309017);
			rot_mat[ 8].SetToValues(-0.809017, 0.309017,-0.500000,-0.309017, 0.500000, 0.809017, 0.500000, 0.809017,-0.309017);
			rot_mat[ 9].SetToValues(-0.309017,-0.500000,-0.809017,-0.500000, 0.809017,-0.309017, 0.809017, 0.309017,-0.500000);
			rot_mat[10].SetToValues( 0.000000,-1.000000, 0.000000, 0.000000, 0.000000,-1.000000, 1.000000, 0.000000, 0.000000);
			rot_mat[11].SetToValues(-0.809017,-0.309017,-0.500000,-0.309017,-0.500000, 0.809017,-0.500000, 0.809017, 0.309017);
			rot_mat[12].SetToValues(-0.500000,-0.809017,-0.309017,-0.809017, 0.309017, 0.500000,-0.309017, 0.500000,-0.809017);
			rot_mat[13].SetToValues(-0.500000,-0.809017, 0.309017,-0.809017, 0.309017,-0.500000, 0.309017,-0.500000,-0.809017);
			rot_mat[14].SetToValues(-0.809017,-0.309017, 0.500000,-0.309017,-0.500000,-0.809017, 0.500000,-0.809017, 0.309017);
			rot_mat[15].SetToValues(-1.000000, 0.000000, 0.000000, 0.000000,-1.000000, 0.000000, 0.000000, 0.000000, 1.000000);
			rot_mat[16].SetToValues( 0.500000,-0.809017,-0.309017, 0.809017, 0.309017, 0.500000,-0.309017,-0.500000, 0.809017);
			rot_mat[17].SetToValues( 0.309017,-0.500000, 0.809017, 0.500000, 0.809017, 0.309017,-0.809017, 0.309017, 0.500000);
			rot_mat[18].SetToValues(-0.309017, 0.500000, 0.809017, 0.500000, 0.809017,-0.309017,-0.809017, 0.309017,-0.500000);
			rot_mat[19].SetToValues(-0.500000, 0.809017,-0.309017, 0.809017, 0.309017,-0.500000,-0.309017,-0.500000,-0.809017);
			rot_mat[20].SetToValues( 0.000000, 0.000000,-1.000000, 1.000000, 0.000000, 0.000000, 0.000000,-1.000000, 0.000000);
			rot_mat[21].SetToValues(-0.309017,-0.500000, 0.809017,-0.500000, 0.809017, 0.309017,-0.809017,-0.309017,-0.500000);
			rot_mat[22].SetToValues(-0.809017, 0.309017, 0.500000,-0.309017, 0.500000,-0.809017,-0.500000,-0.809017,-0.309017);
			rot_mat[23].SetToValues(-0.809017, 0.309017,-0.500000, 0.309017,-0.500000,-0.809017,-0.500000,-0.809017, 0.309017);
			rot_mat[24].SetToValues(-0.309017,-0.500000,-0.809017, 0.500000,-0.809017, 0.309017,-0.809017,-0.309017, 0.500000);
			rot_mat[25].SetToValues( 0.000000,-1.000000, 0.000000, 0.000000, 0.000000, 1.000000,-1.000000, 0.000000, 0.000000);
			rot_mat[26].SetToValues(-0.809017,-0.309017,-0.500000, 0.309017, 0.500000,-0.809017, 0.500000,-0.809017,-0.309017);
			rot_mat[27].SetToValues(-0.500000,-0.809017,-0.309017, 0.809017,-0.309017,-0.500000, 0.309017,-0.500000, 0.809017);
			rot_mat[28].SetToValues(-0.500000,-0.809017, 0.309017, 0.809017,-0.309017, 0.500000,-0.309017, 0.500000, 0.809017);
			rot_mat[29].SetToValues(-0.809017,-0.309017, 0.500000, 0.309017, 0.500000, 0.809017,-0.500000, 0.809017,-0.309017);
			rot_mat[30].SetToValues(-1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000,-1.000000);
			rot_mat[31].SetToValues(-0.500000, 0.809017, 0.309017,-0.809017,-0.309017,-0.500000,-0.309017,-0.500000, 0.809017);
			rot_mat[32].SetToValues(-0.309017, 0.500000,-0.809017,-0.500000,-0.809017,-0.309017,-0.809017, 0.309017, 0.500000);
			rot_mat[33].SetToValues( 0.309017,-0.500000,-0.809017,-0.500000,-0.809017, 0.309017,-0.809017, 0.309017,-0.500000);
			rot_mat[34].SetToValues( 0.500000,-0.809017, 0.309017,-0.809017,-0.309017, 0.500000,-0.309017,-0.500000,-0.809017);
			rot_mat[35].SetToValues( 0.000000, 0.000000, 1.000000,-1.000000, 0.000000, 0.000000, 0.000000,-1.000000, 0.000000);
			rot_mat[36].SetToValues( 0.309017, 0.500000,-0.809017, 0.500000,-0.809017,-0.309017,-0.809017,-0.309017,-0.500000);
			rot_mat[37].SetToValues( 0.809017,-0.309017,-0.500000, 0.309017,-0.500000, 0.809017,-0.500000,-0.809017,-0.309017);
			rot_mat[38].SetToValues( 0.809017,-0.309017, 0.500000,-0.309017, 0.500000, 0.809017,-0.500000,-0.809017, 0.309017);
			rot_mat[39].SetToValues( 0.309017, 0.500000, 0.809017,-0.500000, 0.809017,-0.309017,-0.809017,-0.309017, 0.500000);
			rot_mat[40].SetToValues( 0.000000, 1.000000, 0.000000, 0.000000, 0.000000,-1.000000,-1.000000, 0.000000, 0.000000);
			rot_mat[41].SetToValues( 0.809017, 0.309017, 0.500000,-0.309017,-0.500000, 0.809017, 0.500000,-0.809017,-0.309017);
			rot_mat[42].SetToValues( 0.500000, 0.809017, 0.309017,-0.809017, 0.309017, 0.500000, 0.309017,-0.500000, 0.809017);
			rot_mat[43].SetToValues( 0.500000, 0.809017,-0.309017,-0.809017, 0.309017,-0.500000,-0.309017, 0.500000, 0.809017);
			rot_mat[44].SetToValues( 0.809017, 0.309017,-0.500000,-0.309017,-0.500000,-0.809017,-0.500000, 0.809017,-0.309017);
			rot_mat[45].SetToValues( 1.000000, 0.000000, 0.000000, 0.000000,-1.000000, 0.000000, 0.000000, 0.000000,-1.000000);
			rot_mat[46].SetToValues(-0.500000, 0.809017, 0.309017, 0.809017, 0.309017, 0.500000, 0.309017, 0.500000,-0.809017);
			rot_mat[47].SetToValues(-0.309017, 0.500000,-0.809017, 0.500000, 0.809017, 0.309017, 0.809017,-0.309017,-0.500000);
			rot_mat[48].SetToValues( 0.309017,-0.500000,-0.809017, 0.500000, 0.809017,-0.309017, 0.809017,-0.309017, 0.500000);
			rot_mat[49].SetToValues( 0.500000,-0.809017, 0.309017, 0.809017, 0.309017,-0.500000, 0.309017, 0.500000, 0.809017);
			rot_mat[50].SetToValues( 0.000000, 0.000000, 1.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000);
			rot_mat[51].SetToValues( 0.309017, 0.500000,-0.809017,-0.500000, 0.809017, 0.309017, 0.809017, 0.309017, 0.500000);
			rot_mat[52].SetToValues( 0.809017,-0.309017,-0.500000,-0.309017, 0.500000,-0.809017, 0.500000, 0.809017, 0.309017);
			rot_mat[53].SetToValues( 0.809017,-0.309017, 0.500000, 0.309017,-0.500000,-0.809017, 0.500000, 0.809017,-0.309017);
			rot_mat[54].SetToValues( 0.309017, 0.500000, 0.809017, 0.500000,-0.809017, 0.309017, 0.809017, 0.309017,-0.500000);
			rot_mat[55].SetToValues( 0.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 1.000000, 0.000000, 0.000000);
			rot_mat[56].SetToValues( 0.809017, 0.309017, 0.500000, 0.309017, 0.500000,-0.809017,-0.500000, 0.809017, 0.309017);
			rot_mat[57].SetToValues( 0.500000, 0.809017, 0.309017, 0.809017,-0.309017,-0.500000,-0.309017, 0.500000,-0.809017);
			rot_mat[58].SetToValues( 0.500000, 0.809017,-0.309017, 0.809017,-0.309017, 0.500000, 0.309017,-0.500000,-0.809017);
			rot_mat[59].SetToValues( 0.809017, 0.309017,-0.500000, 0.309017, 0.500000, 0.809017, 0.500000,-0.809017, 0.309017);

/*			rot_mat[ 0].SetToValues( 1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000);
			rot_mat[ 1].SetToValues( 0.500000,-0.809017, 0.309017,-0.809017,-0.309017, 0.500000,-0.309017,-0.500000,-0.809017);
			rot_mat[ 2].SetToValues( 0.309017,-0.500000, 0.809017,-0.500000,-0.809017,-0.309017, 0.809017,-0.309017,-0.500000);
			rot_mat[ 3].SetToValues(-0.309017,-0.500000, 0.809017, 0.500000,-0.809017,-0.309017, 0.809017, 0.309017, 0.500000);
			rot_mat[ 4].SetToValues(-0.500000,-0.809017, 0.309017, 0.809017,-0.309017, 0.500000,-0.309017, 0.500000, 0.809017);
			rot_mat[ 5].SetToValues( 0.000000,-1.000000, 0.000000, 0.000000, 0.000000, 1.000000,-1.000000, 0.000000, 0.000000);
			rot_mat[ 6].SetToValues(-0.309017, 0.500000, 0.809017,-0.500000,-0.809017, 0.309017, 0.809017,-0.309017, 0.500000);
			rot_mat[ 7].SetToValues(-0.809017, 0.309017, 0.500000, 0.309017,-0.500000, 0.809017, 0.500000, 0.809017, 0.309017);
			rot_mat[ 8].SetToValues(-0.809017,-0.309017, 0.500000, 0.309017, 0.500000, 0.809017,-0.500000, 0.809017,-0.309017);
			rot_mat[ 9].SetToValues(-0.309017,-0.500000, 0.809017,-0.500000, 0.809017, 0.309017,-0.809017,-0.309017,-0.500000);
			rot_mat[10].SetToValues( 0.000000, 0.000000, 1.000000,-1.000000, 0.000000, 0.000000, 0.000000,-1.000000, 0.000000);
			rot_mat[11].SetToValues(-0.809017,-0.309017,-0.500000,-0.309017,-0.500000, 0.809017,-0.500000, 0.809017, 0.309017);
			rot_mat[12].SetToValues(-0.500000,-0.809017,-0.309017,-0.809017, 0.309017, 0.500000,-0.309017, 0.500000,-0.809017);
			rot_mat[13].SetToValues(-0.500000,-0.809017, 0.309017,-0.809017, 0.309017,-0.500000, 0.309017,-0.500000,-0.809017);
			rot_mat[14].SetToValues(-0.809017,-0.309017, 0.500000,-0.309017,-0.500000,-0.809017, 0.500000,-0.809017, 0.309017);
			rot_mat[15].SetToValues(-1.000000, 0.000000, 0.000000, 0.000000,-1.000000, 0.000000, 0.000000, 0.000000, 1.000000);
			rot_mat[16].SetToValues( 0.500000, 0.809017,-0.309017,-0.809017, 0.309017,-0.500000,-0.309017, 0.500000, 0.809017);
			rot_mat[17].SetToValues( 0.309017, 0.500000,-0.809017,-0.500000, 0.809017, 0.309017, 0.809017, 0.309017, 0.500000);
			rot_mat[18].SetToValues(-0.309017, 0.500000,-0.809017, 0.500000, 0.809017, 0.309017, 0.809017,-0.309017,-0.500000);
			rot_mat[19].SetToValues(-0.500000, 0.809017,-0.309017, 0.809017, 0.309017,-0.500000,-0.309017,-0.500000,-0.809017);
			rot_mat[20].SetToValues( 0.000000, 1.000000, 0.000000, 0.000000, 0.000000,-1.000000,-1.000000, 0.000000, 0.000000);
			rot_mat[21].SetToValues(-0.309017,-0.500000,-0.809017,-0.500000, 0.809017,-0.309017, 0.809017, 0.309017,-0.500000);
			rot_mat[22].SetToValues(-0.809017,-0.309017,-0.500000, 0.309017, 0.500000,-0.809017, 0.500000,-0.809017,-0.309017);
			rot_mat[23].SetToValues(-0.809017, 0.309017,-0.500000, 0.309017,-0.500000,-0.809017,-0.500000,-0.809017, 0.309017);
			rot_mat[24].SetToValues(-0.309017, 0.500000,-0.809017,-0.500000,-0.809017,-0.309017,-0.809017, 0.309017, 0.500000);
			rot_mat[25].SetToValues( 0.000000, 0.000000,-1.000000,-1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000);
			rot_mat[26].SetToValues(-0.809017, 0.309017, 0.500000,-0.309017, 0.500000,-0.809017,-0.500000,-0.809017,-0.309017);
			rot_mat[27].SetToValues(-0.500000, 0.809017, 0.309017,-0.809017,-0.309017,-0.500000,-0.309017,-0.500000, 0.809017);
			rot_mat[28].SetToValues(-0.500000, 0.809017,-0.309017,-0.809017,-0.309017, 0.500000, 0.309017, 0.500000, 0.809017);
			rot_mat[29].SetToValues(-0.809017, 0.309017,-0.500000,-0.309017, 0.500000, 0.809017, 0.500000, 0.809017,-0.309017);
			rot_mat[30].SetToValues(-1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000,-1.000000);
			rot_mat[31].SetToValues(-0.500000,-0.809017,-0.309017, 0.809017,-0.309017,-0.500000, 0.309017,-0.500000, 0.809017);
			rot_mat[32].SetToValues(-0.309017,-0.500000,-0.809017, 0.500000,-0.809017, 0.309017,-0.809017,-0.309017, 0.500000);
			rot_mat[33].SetToValues( 0.309017,-0.500000,-0.809017,-0.500000,-0.809017, 0.309017,-0.809017, 0.309017,-0.500000);
			rot_mat[34].SetToValues( 0.500000,-0.809017,-0.309017,-0.809017,-0.309017,-0.500000, 0.309017, 0.500000,-0.809017);
			rot_mat[35].SetToValues( 0.000000,-1.000000, 0.000000, 0.000000, 0.000000,-1.000000, 1.000000, 0.000000, 0.000000);
			rot_mat[36].SetToValues( 0.309017, 0.500000,-0.809017, 0.500000,-0.809017,-0.309017,-0.809017,-0.309017,-0.500000);
			rot_mat[37].SetToValues( 0.809017, 0.309017,-0.500000,-0.309017,-0.500000,-0.809017,-0.500000, 0.809017,-0.309017);
			rot_mat[38].SetToValues( 0.809017,-0.309017,-0.500000,-0.309017, 0.500000,-0.809017, 0.500000, 0.809017, 0.309017);
			rot_mat[39].SetToValues( 0.309017,-0.500000,-0.809017, 0.500000, 0.809017,-0.309017, 0.809017,-0.309017, 0.500000);
			rot_mat[40].SetToValues( 0.000000, 0.000000,-1.000000, 1.000000, 0.000000, 0.000000, 0.000000,-1.000000, 0.000000);
			rot_mat[41].SetToValues( 0.809017,-0.309017, 0.500000, 0.309017,-0.500000,-0.809017, 0.500000, 0.809017,-0.309017);
			rot_mat[42].SetToValues( 0.500000,-0.809017, 0.309017, 0.809017, 0.309017,-0.500000, 0.309017, 0.500000, 0.809017);
			rot_mat[43].SetToValues( 0.500000,-0.809017,-0.309017, 0.809017, 0.309017, 0.500000,-0.309017,-0.500000, 0.809017);
			rot_mat[44].SetToValues( 0.809017,-0.309017,-0.500000, 0.309017,-0.500000, 0.809017,-0.500000,-0.809017,-0.309017);
			rot_mat[45].SetToValues( 1.000000, 0.000000, 0.000000, 0.000000,-1.000000, 0.000000, 0.000000, 0.000000,-1.000000);
			rot_mat[46].SetToValues(-0.500000, 0.809017, 0.309017, 0.809017, 0.309017, 0.500000, 0.309017, 0.500000,-0.809017);
			rot_mat[47].SetToValues(-0.309017, 0.500000, 0.809017, 0.500000, 0.809017,-0.309017,-0.809017, 0.309017,-0.500000);
			rot_mat[48].SetToValues( 0.309017, 0.500000, 0.809017,-0.500000, 0.809017,-0.309017,-0.809017,-0.309017, 0.500000);
			rot_mat[49].SetToValues( 0.500000, 0.809017, 0.309017,-0.809017, 0.309017, 0.500000, 0.309017,-0.500000, 0.809017);
			rot_mat[50].SetToValues( 0.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 1.000000, 0.000000, 0.000000);
			rot_mat[51].SetToValues( 0.309017,-0.500000, 0.809017, 0.500000, 0.809017, 0.309017,-0.809017, 0.309017, 0.500000);
			rot_mat[52].SetToValues( 0.809017,-0.309017, 0.500000,-0.309017, 0.500000, 0.809017,-0.500000,-0.809017, 0.309017);
			rot_mat[53].SetToValues( 0.809017, 0.309017, 0.500000,-0.309017,-0.500000, 0.809017, 0.500000,-0.809017,-0.309017);
			rot_mat[54].SetToValues( 0.309017, 0.500000, 0.809017, 0.500000,-0.809017, 0.309017, 0.809017, 0.309017,-0.500000);
			rot_mat[55].SetToValues( 0.000000, 0.000000, 1.000000, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000, 0.000000);
			rot_mat[56].SetToValues( 0.809017, 0.309017,-0.500000, 0.309017, 0.500000, 0.809017, 0.500000,-0.809017, 0.309017);
			rot_mat[57].SetToValues( 0.500000, 0.809017,-0.309017, 0.809017,-0.309017, 0.500000, 0.309017,-0.500000,-0.809017);
			rot_mat[58].SetToValues( 0.500000, 0.809017, 0.309017, 0.809017,-0.309017,-0.500000,-0.309017, 0.500000,-0.809017);
			rot_mat[59].SetToValues( 0.809017, 0.309017, 0.500000, 0.309017, 0.500000,-0.809017,-0.500000, 0.809017, 0.309017);
*/
			return;
		}
	}

	MyPrintWithDetails("Error: Invalid symmetry symbol\n");
	abort();
}

SymmetryMatrix::~SymmetryMatrix()
{
	if (rot_mat != NULL)
	{
		delete [] rot_mat;
	}
}

void SymmetryMatrix::PrintMatrices()
{
	MyDebugAssertTrue(rot_mat != NULL, "Symmetry matrices have not been calculated");

	for (int i = 0; i < number_of_matrices; i++)
	{
		wxPrintf("\n%9.6f,%9.6f,%9.6f\n%9.6f,%9.6f,%9.6f\n%9.6f,%9.6f,%9.6f\n",rot_mat[i].m[0][0],rot_mat[i].m[1][0],rot_mat[i].m[2][0],
					rot_mat[i].m[0][1],rot_mat[i].m[1][1],rot_mat[i].m[2][1],rot_mat[i].m[0][2],rot_mat[i].m[1][2],rot_mat[i].m[2][2]);
	}
}
