//	James Z. Chen
//	January 1, 2005
//	All rights reserved

#ifndef __MISC_H
#define __MISC_H 1

#include "/usr/include/stdio.h"
#include "/usr/include/stdlib.h"
#include "parameter.h"


extern char message[LINE_MAX];
extern char emsRunMode;


// system message display
void errReport(char *err);
void msgReport(char *msg);
void askSaveProj(void);
char makeDirectory(char *dirName);

// EMS_TRUE = system busy
void systemStatus(char status);

// file management
void simpleFilePath(char *fileName);
void getFilePath(char *file_name, char *pathName, char *fileName);
void removeExt(char *file_name, char *ext_name);
long fileSize(FILE *fp);

// ENDIAN byte swapping
inline void byteSwap(char *data, int bytes, long items)
{
	char bswap;
	int i, j = 0;

	switch ( bytes ) {
	case 2:
		for( i=0; i<items; i++ ) {
			bswap = data[j];
			data[j] = data[j+1];
			data[j+1] = bswap;
			j = j + bytes;
		}
		break;
	case 4:
		for( i=0; i<items; i++ ) {
			bswap = data[j];
			data[j] = data[j+3];
			data[j+3] = bswap;
			bswap = data[j+1];
			data[j+1] = data[j+2];
			data[j+2] = bswap;
			j = j + bytes;
		}
		break;
	}
}


// swap value between two variables
inline void swapValF(float &src, float &dst)
{
	float val;

	val = src;
	src = dst;
	dst = val;
}


// set a square matrix to identity
inline void setIdentity(double *m, int dimension)
{
	int i, j;

	for ( i=0; i<dimension; i++ ) {
		for ( j=0; j<dimension; j++ )
			m[i*dimension+j] = 0.0;
		m[i*dimension+i] = 1.0;
	}
}

#endif
