//	James Z. Chen
//	January 1, 2005
//	All rights reserved

#include "/usr/include/stdio.h"
#include "/usr/include/stdlib.h"
#include "../signature/include/FL/Fl.H"
#include "gui.h"
#include "logo.h"
#include "panel.h"
#include "images.h"


char emsRunMode;
EMS_Panel *cPanel=NULL;
EMS_Project *project=NULL;
EMS_Images *functImage=NULL;
DisplayPanel_UI *EMS_DP=NULL;
StartUp_UI *LoginWindow=NULL;


void autoLogin(void *dummy)
{
	EMS_Login_CB(EMS_TRUE);
}


int main(int argc, char **argv)
{
	int index, lineSize, mode;
	char file_name[NAMESIZE], buffer[LINE_MAX];
	FILE *fp;

	// system initializaiton
	project = new EMS_Project;
	functImage = new EMS_Images;
	EMS_DP = new DisplayPanel_UI;
	cPanel = new EMS_Panel;

	// launch GUI mode
	if ( argc == 1 ) {
		emsRunMode = EMS_GUI_MODE;
		Fl::visual(FL_DOUBLE | FL_RGB | FL_ALPHA | FL_DEPTH);

		// launch startup window
		LoginWindow = new StartUp_UI;
		LoginWindow->show();
		Fl::add_timeout(3.0, autoLogin);

		Fl::run();
	}

	// launch COM mode
	else if ( argc == 2 ) {
		emsRunMode = EMS_COM_MODE;
		strcpy(file_name, argv[1]);
		
		if ( (fp=fopen(file_name, "r")) != NULL ) {
			fgets(buffer, LINE_MAX, fp);
			fclose(fp);

			// test for SCREENING / ALIGNMENT project
			mode = EMS_FALSE;
			lineSize = strlen(buffer) - 1;

			for ( index=0; index<lineSize; index++ ) {
				if ( !strncmp(buffer+index, " : ", 3) ) {
					mode = EMS_PRJ_SCREEN;
					break;
				}
			}

			switch ( mode ) {
			case EMS_PRJ_SCREEN:
				project->runProject(file_name);
				break;
			case EMS_FALSE:
				printf("Unknown project definition. Exit!\n\n");
				break;
			}
		}
		else {
			printf("Cannot open the project file. Exit!\n\n");
			exit(1);
		}
	}

	// display program usage and exit
	else {
		printf("\n");
		printf("Welcome to SIGNATURE!\n\n");
		printf("<signature> launches the interactive mode.\n");
		printf("<signature [project file]> launches the computing mode.\n");
		printf("\n");
	}
	
	if ( EMS_DP != NULL ) delete EMS_DP;
	if ( cPanel != NULL ) delete cPanel;
	if ( project != NULL ) delete project;
	if ( functImage != NULL ) delete functImage;

    return(0);
}
