//	James Z. Chen
//	January 1, 2005
//	All rights reserved

#ifndef gui_h
#define gui_h
#include "../signature/include/FL/Fl.H"
#include "../signature/include/FL/Fl_Double_Window.H"
#include "../signature/include/FL/Fl_Menu_Bar.H"
#include "interact.h"
#include "../signature/include/FL/Fl_Group.H"
#include "../signature/include/FL/Fl_Button.H"
#include "../signature/include/FL/Fl_Output.H"
#include "display.h"
#include "../signature/include/FL/Fl_Value_Output.H"
#include "../signature/include/FL/Fl_Value_Input.H"
#include "../signature/include/FL/Fl_Box.H"
#include "../signature/include/FL/Fl_Roller.H"
#include "../signature/include/FL/Fl_Value_Slider.H"
#include "../signature/include/FL/Fl_Input.H"
#include "../signature/include/FL/Fl_Choice.H"
#include "../signature/include/FL/Fl_Light_Button.H"
#include "../signature/include/FL/Fl_Check_Button.H"
#include "misc.h"

class DisplayPanel_UI {
public:
  DisplayPanel_UI();
  Fl_Double_Window *DisplayWindow;
  static Fl_Menu_Item menu_Manu[];
private:
  inline void cb_New_i(Fl_Menu_*, void*);
  static void cb_New(Fl_Menu_*, void*);
  inline void cb_Open_i(Fl_Menu_*, void*);
  static void cb_Open(Fl_Menu_*, void*);
  inline void cb_Open1_i(Fl_Menu_*, void*);
  static void cb_Open1(Fl_Menu_*, void*);
  inline void cb_Save_i(Fl_Menu_*, void*);
  static void cb_Save(Fl_Menu_*, void*);
  inline void cb_Close_i(Fl_Menu_*, void*);
  static void cb_Close(Fl_Menu_*, void*);
  inline void cb_Exit_i(Fl_Menu_*, void*);
  static void cb_Exit(Fl_Menu_*, void*);
  inline void cb_Load_i(Fl_Menu_*, void*);
  static void cb_Load(Fl_Menu_*, void*);
  inline void cb_Load1_i(Fl_Menu_*, void*);
  static void cb_Load1(Fl_Menu_*, void*);
  inline void cb_Load2_i(Fl_Menu_*, void*);
  static void cb_Load2(Fl_Menu_*, void*);
  inline void cb_Save1_i(Fl_Menu_*, void*);
  static void cb_Save1(Fl_Menu_*, void*);
  inline void cb_Load3_i(Fl_Menu_*, void*);
  static void cb_Load3(Fl_Menu_*, void*);
  inline void cb_Include_i(Fl_Menu_*, void*);
  static void cb_Include(Fl_Menu_*, void*);
  inline void cb_Exclude_i(Fl_Menu_*, void*);
  static void cb_Exclude(Fl_Menu_*, void*);
  inline void cb_PTK_i(Fl_Menu_*, void*);
  static void cb_PTK(Fl_Menu_*, void*);
  inline void cb_PLT_i(Fl_Menu_*, void*);
  static void cb_PLT(Fl_Menu_*, void*);
  inline void cb_SPD_i(Fl_Menu_*, void*);
  static void cb_SPD(Fl_Menu_*, void*);
  inline void cb_PTK1_i(Fl_Menu_*, void*);
  static void cb_PTK1(Fl_Menu_*, void*);
  inline void cb_PLT1_i(Fl_Menu_*, void*);
  static void cb_PLT1(Fl_Menu_*, void*);
  inline void cb_SPD1_i(Fl_Menu_*, void*);
  static void cb_SPD1(Fl_Menu_*, void*);
  inline void cb_Save2_i(Fl_Menu_*, void*);
  static void cb_Save2(Fl_Menu_*, void*);
  inline void cb_Clear_i(Fl_Menu_*, void*);
  static void cb_Clear(Fl_Menu_*, void*);
  inline void cb_2D_i(Fl_Menu_*, void*);
  static void cb_2D(Fl_Menu_*, void*);
  inline void cb_Image_i(Fl_Menu_*, void*);
  static void cb_Image(Fl_Menu_*, void*);
  inline void cb_Digital_i(Fl_Menu_*, void*);
  static void cb_Digital(Fl_Menu_*, void*);
  inline void cb_About_i(Fl_Menu_*, void*);
  static void cb_About(Fl_Menu_*, void*);
  inline void cb_Documentation_i(Fl_Menu_*, void*);
  static void cb_Documentation(Fl_Menu_*, void*);
public:
  Fl_Button *btnShowMask;
private:
  inline void cb_btnShowMask_i(Fl_Button*, void*);
  static void cb_btnShowMask(Fl_Button*, void*);
public:
  Fl_Button *btnShowPrtk;
private:
  inline void cb_btnShowPrtk_i(Fl_Button*, void*);
  static void cb_btnShowPrtk(Fl_Button*, void*);
public:
  Fl_Button *btnShowZoom;
private:
  inline void cb_btnShowZoom_i(Fl_Button*, void*);
  static void cb_btnShowZoom(Fl_Button*, void*);
public:
  Fl_Button *btnCircle;
private:
  inline void cb_btnCircle_i(Fl_Button*, void*);
  static void cb_btnCircle(Fl_Button*, void*);
public:
  Fl_Button *btnLines;
private:
  inline void cb_btnLines_i(Fl_Button*, void*);
  static void cb_btnLines(Fl_Button*, void*);
public:
  Fl_Button *btnPaint;
private:
  inline void cb_btnPaint_i(Fl_Button*, void*);
  static void cb_btnPaint(Fl_Button*, void*);
public:
  Fl_Button *btnErase;
private:
  inline void cb_btnErase_i(Fl_Button*, void*);
  static void cb_btnErase(Fl_Button*, void*);
public:
  Fl_Output *dspProj;
  Fl_Output *dspFilm;
  EMS_Display *imgDisplay;
  Fl_Group *grpMcrgraph;
  Fl_Output *dspFilmFile;
private:
  inline void cb__i(Fl_Button*, void*);
  static void cb_(Fl_Button*, void*);
public:
  Fl_Value_Output *dspFilmX;
  Fl_Value_Output *dspFilmY;
  Fl_Value_Input *dspPixSize;
private:
  inline void cb_dspPixSize_i(Fl_Value_Input*, void*);
  static void cb_dspPixSize(Fl_Value_Input*, void*);
public:
  Fl_Box *imgInform;
  Fl_Button *btnSpecMode;
private:
  inline void cb_btnSpecMode_i(Fl_Button*, void*);
  static void cb_btnSpecMode(Fl_Button*, void*);
public:
  Fl_Button *btnHstgMode;
private:
  inline void cb_btnHstgMode_i(Fl_Button*, void*);
  static void cb_btnHstgMode(Fl_Button*, void*);
public:
  Fl_Value_Input *valSpecSize;
private:
  inline void cb_valSpecSize_i(Fl_Value_Input*, void*);
  static void cb_valSpecSize(Fl_Value_Input*, void*);
  inline void cb_Mark_i(Fl_Button*, void*);
  static void cb_Mark(Fl_Button*, void*);
public:
  Fl_Roller *specBrit;
private:
  inline void cb_specBrit_i(Fl_Roller*, void*);
  static void cb_specBrit(Fl_Roller*, void*);
public:
  Fl_Roller *specCntr;
private:
  inline void cb_specCntr_i(Fl_Roller*, void*);
  static void cb_specCntr(Fl_Roller*, void*);
public:
  Fl_Value_Slider *sldVarH;
private:
  inline void cb_sldVarH_i(Fl_Value_Slider*, void*);
  static void cb_sldVarH(Fl_Value_Slider*, void*);
public:
  Fl_Value_Slider *sldVarL;
private:
  inline void cb_sldVarL_i(Fl_Value_Slider*, void*);
  static void cb_sldVarL(Fl_Value_Slider*, void*);
public:
  Fl_Value_Input *valVarbox;
private:
  inline void cb_valVarbox_i(Fl_Value_Input*, void*);
  static void cb_valVarbox(Fl_Value_Input*, void*);
public:
  Fl_Value_Input *valEdge;
private:
  inline void cb_valEdge_i(Fl_Value_Input*, void*);
  static void cb_valEdge(Fl_Value_Input*, void*);
public:
  Fl_Value_Input *valBrush;
private:
  inline void cb_valBrush_i(Fl_Value_Input*, void*);
  static void cb_valBrush(Fl_Value_Input*, void*);
  inline void cb_Apply_i(Fl_Button*, void*);
  static void cb_Apply(Fl_Button*, void*);
  inline void cb_Clear1_i(Fl_Button*, void*);
  static void cb_Clear1(Fl_Button*, void*);
public:
  Fl_Input *dspKeyNote;
  Fl_Group *grpTemplate;
  Fl_Output *dspTempFile;
private:
  inline void cb_1_i(Fl_Button*, void*);
  static void cb_1(Fl_Button*, void*);
public:
  Fl_Value_Output *dspTempX;
  Fl_Value_Output *dspTempY;
  Fl_Value_Output *dspTempN;
  Fl_Value_Slider *sldLCFrad;
private:
  inline void cb_sldLCFrad_i(Fl_Value_Slider*, void*);
  static void cb_sldLCFrad(Fl_Value_Slider*, void*);
public:
  Fl_Value_Slider *sldSCFrad;
private:
  inline void cb_sldSCFrad_i(Fl_Value_Slider*, void*);
  static void cb_sldSCFrad(Fl_Value_Slider*, void*);
public:
  Fl_Value_Slider *sldSCFradc;
private:
  inline void cb_sldSCFradc_i(Fl_Value_Slider*, void*);
  static void cb_sldSCFradc(Fl_Value_Slider*, void*);
  inline void cb_Apply1_i(Fl_Button*, void*);
  static void cb_Apply1(Fl_Button*, void*);
public:
  Fl_Value_Input *valRefSelect;
private:
  inline void cb_valRefSelect_i(Fl_Value_Input*, void*);
  static void cb_valRefSelect(Fl_Value_Input*, void*);
public:
  Fl_Button *btnTempInc;
private:
  inline void cb_btnTempInc_i(Fl_Button*, void*);
  static void cb_btnTempInc(Fl_Button*, void*);
  static Fl_Menu_Item menu_Target[];
  inline void cb_L_i(Fl_Menu_*, void*);
  static void cb_L(Fl_Menu_*, void*);
  inline void cb_L1_i(Fl_Menu_*, void*);
  static void cb_L1(Fl_Menu_*, void*);
public:
  Fl_Value_Input *valBrush2;
private:
  inline void cb_valBrush2_i(Fl_Value_Input*, void*);
  static void cb_valBrush2(Fl_Value_Input*, void*);
public:
  Fl_Light_Button *btnEditFrame;
private:
  inline void cb_btnEditFrame_i(Fl_Light_Button*, void*);
  static void cb_btnEditFrame(Fl_Light_Button*, void*);
  inline void cb_Sync_i(Fl_Button*, void*);
  static void cb_Sync(Fl_Button*, void*);
  inline void cb_Clear2_i(Fl_Button*, void*);
  static void cb_Clear2(Fl_Button*, void*);
public:
  Fl_Check_Button *btnRotate;
private:
  inline void cb_btnRotate_i(Fl_Check_Button*, void*);
  static void cb_btnRotate(Fl_Check_Button*, void*);
public:
  Fl_Value_Input *dspRotaRange;
private:
  inline void cb_dspRotaRange_i(Fl_Value_Input*, void*);
  static void cb_dspRotaRange(Fl_Value_Input*, void*);
public:
  Fl_Value_Input *dspRotaDelta;
private:
  inline void cb_dspRotaDelta_i(Fl_Value_Input*, void*);
  static void cb_dspRotaDelta(Fl_Value_Input*, void*);
public:
  Fl_Check_Button *btnL2Mask;
private:
  inline void cb_btnL2Mask_i(Fl_Check_Button*, void*);
  static void cb_btnL2Mask(Fl_Check_Button*, void*);
public:
  Fl_Group *grpParticle;
  Fl_Group *imgMonitor;
  Fl_Box *monitor1;
  Fl_Button *btnCross1;
private:
  inline void cb_btnCross1_i(Fl_Button*, void*);
  static void cb_btnCross1(Fl_Button*, void*);
public:
  Fl_Button *btnSpec;
private:
  inline void cb_btnSpec_i(Fl_Button*, void*);
  static void cb_btnSpec(Fl_Button*, void*);
public:
  Fl_Value_Input *mon1Resz;
private:
  inline void cb_mon1Resz_i(Fl_Value_Input*, void*);
  static void cb_mon1Resz(Fl_Value_Input*, void*);
public:
  Fl_Value_Input *mon1Blur;
private:
  inline void cb_mon1Blur_i(Fl_Value_Input*, void*);
  static void cb_mon1Blur(Fl_Value_Input*, void*);
public:
  Fl_Box *monitor2;
  Fl_Button *btnCross2;
private:
  inline void cb_btnCross2_i(Fl_Button*, void*);
  static void cb_btnCross2(Fl_Button*, void*);
public:
  Fl_Button *btnRefr;
private:
  inline void cb_btnRefr_i(Fl_Button*, void*);
  static void cb_btnRefr(Fl_Button*, void*);
public:
  Fl_Value_Input *mon2Resz;
private:
  inline void cb_mon2Resz_i(Fl_Value_Input*, void*);
  static void cb_mon2Resz(Fl_Value_Input*, void*);
public:
  Fl_Value_Input *mon2Blur;
private:
  inline void cb_mon2Blur_i(Fl_Value_Input*, void*);
  static void cb_mon2Blur(Fl_Value_Input*, void*);
public:
  Fl_Roller *monBrit;
private:
  inline void cb_monBrit_i(Fl_Roller*, void*);
  static void cb_monBrit(Fl_Roller*, void*);
public:
  Fl_Roller *monCntr;
private:
  inline void cb_monCntr_i(Fl_Roller*, void*);
  static void cb_monCntr(Fl_Roller*, void*);
public:
  Fl_Value_Slider *sldScore;
private:
  inline void cb_Accept_i(Fl_Button*, void*);
  static void cb_Accept(Fl_Button*, void*);
  inline void cb_Reject_i(Fl_Button*, void*);
  static void cb_Reject(Fl_Button*, void*);
  inline void cb_Undo_i(Fl_Button*, void*);
  static void cb_Undo(Fl_Button*, void*);
public:
  Fl_Value_Output *dspCount;
  Fl_Value_Input *dspPrtkSize;
private:
  inline void cb_dspPrtkSize_i(Fl_Value_Input*, void*);
  static void cb_dspPrtkSize(Fl_Value_Input*, void*);
public:
  Fl_Value_Input *dspDist;
private:
  inline void cb_dspDist_i(Fl_Value_Input*, void*);
  static void cb_dspDist(Fl_Value_Input*, void*);
public:
  Fl_Value_Input *dspDownSize;
private:
  inline void cb_dspDownSize_i(Fl_Value_Input*, void*);
  static void cb_dspDownSize(Fl_Value_Input*, void*);
public:
  Fl_Value_Input *dspFrameSize;
private:
  inline void cb_dspFrameSize_i(Fl_Value_Input*, void*);
  static void cb_dspFrameSize(Fl_Value_Input*, void*);
public:
  Fl_Value_Output *aveLCF;
  Fl_Value_Output *maxLCF;
  Fl_Value_Output *cntLCF;
  Fl_Value_Slider *sldLCF;
private:
  inline void cb_sldLCF_i(Fl_Value_Slider*, void*);
  static void cb_sldLCF(Fl_Value_Slider*, void*);
public:
  Fl_Value_Output *aveSCF;
  Fl_Value_Output *maxSCF;
  Fl_Value_Output *cntSCF;
  Fl_Value_Slider *sldSCF;
private:
  inline void cb_sldSCF_i(Fl_Value_Slider*, void*);
  static void cb_sldSCF(Fl_Value_Slider*, void*);
public:
  Fl_Button *btnTestRun;
private:
  inline void cb_btnTestRun_i(Fl_Button*, void*);
  static void cb_btnTestRun(Fl_Button*, void*);
  inline void cb_Screening_i(Fl_Button*, void*);
  static void cb_Screening(Fl_Button*, void*);
public:
  Fl_Button *btnGotoEditor;
private:
  inline void cb_btnGotoEditor_i(Fl_Button*, void*);
  static void cb_btnGotoEditor(Fl_Button*, void*);
public:
  Fl_Group *grp2DImage;
  Fl_Group *filaMonitor;
  Fl_Box *monitor3;
  Fl_Roller *mon3Brit;
private:
  inline void cb_mon3Brit_i(Fl_Roller*, void*);
  static void cb_mon3Brit(Fl_Roller*, void*);
public:
  Fl_Roller *mon3Cntr;
private:
  inline void cb_mon3Cntr_i(Fl_Roller*, void*);
  static void cb_mon3Cntr(Fl_Roller*, void*);
public:
  Fl_Button *btnCross3;
private:
  inline void cb_btnCross3_i(Fl_Button*, void*);
  static void cb_btnCross3(Fl_Button*, void*);
public:
  Fl_Value_Output *dspCropX;
  Fl_Value_Output *dspCropY;
  Fl_Value_Input *valShftX;
private:
  inline void cb_valShftX_i(Fl_Value_Input*, void*);
  static void cb_valShftX(Fl_Value_Input*, void*);
public:
  Fl_Value_Input *valShftY;
private:
  inline void cb_valShftY_i(Fl_Value_Input*, void*);
  static void cb_valShftY(Fl_Value_Input*, void*);
public:
  Fl_Value_Input *valExtnX;
private:
  inline void cb_valExtnX_i(Fl_Value_Input*, void*);
  static void cb_valExtnX(Fl_Value_Input*, void*);
public:
  Fl_Value_Input *valExtnY;
private:
  inline void cb_valExtnY_i(Fl_Value_Input*, void*);
  static void cb_valExtnY(Fl_Value_Input*, void*);
public:
  Fl_Value_Input *mon3Resz;
private:
  inline void cb_mon3Resz_i(Fl_Value_Input*, void*);
  static void cb_mon3Resz(Fl_Value_Input*, void*);
public:
  Fl_Value_Input *valRotate;
private:
  inline void cb_valRotate_i(Fl_Value_Input*, void*);
  static void cb_valRotate(Fl_Value_Input*, void*);
  inline void cb_Save3_i(Fl_Button*, void*);
  static void cb_Save3(Fl_Button*, void*);
  inline void cb_Clear3_i(Fl_Button*, void*);
  static void cb_Clear3(Fl_Button*, void*);
public:
  Fl_Check_Button *btnOrtho;
private:
  inline void cb_btnOrtho_i(Fl_Check_Button*, void*);
  static void cb_btnOrtho(Fl_Check_Button*, void*);
public:
  Fl_Value_Input *dspFilaDiam;
private:
  inline void cb_dspFilaDiam_i(Fl_Value_Input*, void*);
  static void cb_dspFilaDiam(Fl_Value_Input*, void*);
public:
  Fl_Value_Input *dspUnitLeng;
private:
  inline void cb_dspUnitLeng_i(Fl_Value_Input*, void*);
  static void cb_dspUnitLeng(Fl_Value_Input*, void*);
public:
  Fl_Value_Input *dspUnitCrox;
private:
  inline void cb_dspUnitCrox_i(Fl_Value_Input*, void*);
  static void cb_dspUnitCrox(Fl_Value_Input*, void*);
public:
  Fl_Light_Button *btnFilaAve;
private:
  inline void cb_btnFilaAve_i(Fl_Light_Button*, void*);
  static void cb_btnFilaAve(Fl_Light_Button*, void*);
  inline void cb_Apply2_i(Fl_Button*, void*);
  static void cb_Apply2(Fl_Button*, void*);
  static Fl_Menu_Item menu_Functions[];
  inline void cb_Normalization_i(Fl_Menu_*, void*);
  static void cb_Normalization(Fl_Menu_*, void*);
  inline void cb_Band_i(Fl_Menu_*, void*);
  static void cb_Band(Fl_Menu_*, void*);
  inline void cb_Invert_i(Fl_Menu_*, void*);
  static void cb_Invert(Fl_Menu_*, void*);
  inline void cb_Flatten_i(Fl_Menu_*, void*);
  static void cb_Flatten(Fl_Menu_*, void*);
  inline void cb_Pixel_i(Fl_Menu_*, void*);
  static void cb_Pixel(Fl_Menu_*, void*);
  inline void cb_Horizontal_i(Fl_Menu_*, void*);
  static void cb_Horizontal(Fl_Menu_*, void*);
  inline void cb_Vertical_i(Fl_Menu_*, void*);
  static void cb_Vertical(Fl_Menu_*, void*);
public:
  Fl_Value_Input *valParam4;
  Fl_Value_Input *valParam5;
  Fl_Value_Input *valParam6;
private:
  inline void cb_Apply3_i(Fl_Button*, void*);
  static void cb_Apply3(Fl_Button*, void*);
public:
  Fl_Group *functImages;
  Fl_Output *dspImageFile;
private:
  inline void cb_2_i(Fl_Button*, void*);
  static void cb_2(Fl_Button*, void*);
public:
  Fl_Value_Output *dspImgX;
  Fl_Value_Output *dspImgY;
  Fl_Value_Output *dspImgN;
  Fl_Value_Output *dspImgMin;
  Fl_Value_Output *dspImgAve;
  Fl_Value_Output *dspImgMax;
  Fl_Value_Output *dspImgVar;
private:
  inline void cb_Append_i(Fl_Button*, void*);
  static void cb_Append(Fl_Button*, void*);
  inline void cb_Save4_i(Fl_Button*, void*);
  static void cb_Save4(Fl_Button*, void*);
  inline void cb_Close1_i(Fl_Button*, void*);
  static void cb_Close1(Fl_Button*, void*);
  inline void cb_Extract_i(Fl_Button*, void*);
  static void cb_Extract(Fl_Button*, void*);
  inline void cb_Delete_i(Fl_Button*, void*);
  static void cb_Delete(Fl_Button*, void*);
  inline void cb_Clear4_i(Fl_Button*, void*);
  static void cb_Clear4(Fl_Button*, void*);
public:
  Fl_Value_Input *valFrame0;
private:
  inline void cb_valFrame0_i(Fl_Value_Input*, void*);
  static void cb_valFrame0(Fl_Value_Input*, void*);
  inline void cb_3_i(Fl_Button*, void*);
  static void cb_3(Fl_Button*, void*);
  inline void cb_4_i(Fl_Button*, void*);
  static void cb_4(Fl_Button*, void*);
  inline void cb_5_i(Fl_Button*, void*);
  static void cb_5(Fl_Button*, void*);
  inline void cb_6_i(Fl_Button*, void*);
  static void cb_6(Fl_Button*, void*);
  inline void cb_ID_i(Fl_Button*, void*);
  static void cb_ID(Fl_Button*, void*);
public:
  Fl_Choice *dspQuality;
  static Fl_Menu_Item menu_dspQuality[];
private:
  inline void cb_Normal_i(Fl_Menu_*, void*);
  static void cb_Normal(Fl_Menu_*, void*);
  inline void cb_Fine_i(Fl_Menu_*, void*);
  static void cb_Fine(Fl_Menu_*, void*);
  inline void cb_Super_i(Fl_Menu_*, void*);
  static void cb_Super(Fl_Menu_*, void*);
public:
  Fl_Value_Input *valDispScale;
private:
  inline void cb_valDispScale_i(Fl_Value_Input*, void*);
  static void cb_valDispScale(Fl_Value_Input*, void*);
  inline void cb_Display_i(Fl_Button*, void*);
  static void cb_Display(Fl_Button*, void*);
  static Fl_Menu_Item menu_Functions1[];
  inline void cb_Normalization1_i(Fl_Menu_*, void*);
  static void cb_Normalization1(Fl_Menu_*, void*);
  inline void cb_Intensity_i(Fl_Menu_*, void*);
  static void cb_Intensity(Fl_Menu_*, void*);
  inline void cb_Band1_i(Fl_Menu_*, void*);
  static void cb_Band1(Fl_Menu_*, void*);
  inline void cb_Intensity1_i(Fl_Menu_*, void*);
  static void cb_Intensity1(Fl_Menu_*, void*);
  inline void cb_Cropping_i(Fl_Menu_*, void*);
  static void cb_Cropping(Fl_Menu_*, void*);
  inline void cb_Frame_i(Fl_Menu_*, void*);
  static void cb_Frame(Fl_Menu_*, void*);
  inline void cb_Pixel1_i(Fl_Menu_*, void*);
  static void cb_Pixel1(Fl_Menu_*, void*);
  inline void cb_Rotational_i(Fl_Menu_*, void*);
  static void cb_Rotational(Fl_Menu_*, void*);
  inline void cb_Rotational1_i(Fl_Menu_*, void*);
  static void cb_Rotational1(Fl_Menu_*, void*);
  inline void cb_Pixel2_i(Fl_Menu_*, void*);
  static void cb_Pixel2(Fl_Menu_*, void*);
public:
  Fl_Value_Input *valParam1;
  Fl_Value_Input *valParam2;
  Fl_Value_Input *valParam3;
private:
  inline void cb_Apply4_i(Fl_Button*, void*);
  static void cb_Apply4(Fl_Button*, void*);
public:
  Fl_Group *functDigitGel;
  Fl_Value_Slider *sldGelMask;
private:
  inline void cb_sldGelMask_i(Fl_Value_Slider*, void*);
  static void cb_sldGelMask(Fl_Value_Slider*, void*);
public:
  Fl_Value_Output *gelMassMin;
  Fl_Value_Output *gelMassAve;
  Fl_Value_Output *gelMassMax;
  Fl_Value_Output *gelMassVar;
private:
  inline void cb_Apply5_i(Fl_Button*, void*);
  static void cb_Apply5(Fl_Button*, void*);
public:
  Fl_Value_Output *gelPrtkTotal;
  Fl_Value_Output *gelPrtkSelect;
  Fl_Value_Input *gelMassLow;
private:
  inline void cb_gelMassLow_i(Fl_Value_Input*, void*);
  static void cb_gelMassLow(Fl_Value_Input*, void*);
public:
  Fl_Value_Input *gelMassHigh;
private:
  inline void cb_gelMassHigh_i(Fl_Value_Input*, void*);
  static void cb_gelMassHigh(Fl_Value_Input*, void*);
  inline void cb_Apply6_i(Fl_Button*, void*);
  static void cb_Apply6(Fl_Button*, void*);
  inline void cb_Commit_i(Fl_Button*, void*);
  static void cb_Commit(Fl_Button*, void*);
public:
  Fl_Output *msgBoard;
  Fl_Light_Button *btnMcrgraph;
private:
  inline void cb_btnMcrgraph_i(Fl_Light_Button*, void*);
  static void cb_btnMcrgraph(Fl_Light_Button*, void*);
public:
  Fl_Light_Button *btnTemplate;
private:
  inline void cb_btnTemplate_i(Fl_Light_Button*, void*);
  static void cb_btnTemplate(Fl_Light_Button*, void*);
public:
  Fl_Light_Button *btnParticle;
private:
  inline void cb_btnParticle_i(Fl_Light_Button*, void*);
  static void cb_btnParticle(Fl_Light_Button*, void*);
public:
  Fl_Roller *sldBrit;
private:
  inline void cb_sldBrit_i(Fl_Roller*, void*);
  static void cb_sldBrit(Fl_Roller*, void*);
public:
  Fl_Roller *sldCntr;
private:
  inline void cb_sldCntr_i(Fl_Roller*, void*);
  static void cb_sldCntr(Fl_Roller*, void*);
public:
  Fl_Box *indicator;
  void show();
};
#endif
