//	James Z. Chen
//	January 1, 2005
//	All rights reserved

#ifndef __EMS_ALGEBRA_H
#define __EMS_ALGEBRA_H 1

#include "/usr/include/stdio.h"
#include "/usr/include/stdlib.h"
#include "/usr/include/math.h"
#include "parameter.h"

#define EMS_FLAT_TERM		6		// LSQ polynomial fitting


void linearEquas(double A[EMS_FLAT_TERM][EMS_FLAT_TERM], double B[EMS_FLAT_TERM]);


inline void matrix3X3(double srcA[3][3], double srcB[3][3], double dst[3][3])
{
	int x, y;

	for ( y=0; y<3; y++ ) {
		for ( x=0; x<3; x++ ) {
			dst[x][y] = srcA[x][0]*srcB[0][y] + srcA[x][1]*srcB[1][y] + srcA[x][2]*srcB[2][y];
		}
	}
}


inline void matrix3X1(double srcA[3][3], double srcB[3], double dst[3])
{
	int i;

	for ( i=0; i<3; i++ )
		dst[i] = srcA[i][0]*srcB[0] + srcA[i][1]*srcB[1] + srcA[i][2]*srcB[2];
}


#endif
