//	James Z. Chen
//	January 1, 2005
//	All rights reserved

#include "algebra.h"
#include "../signature/include/gsl/gsl_linalg.h"
#include "../signature/include/gsl/gsl_math.h"
#include "../signature/include/gsl/gsl_eigen.h"


void linearEquas(double A[EMS_FLAT_TERM][EMS_FLAT_TERM], double B[EMS_FLAT_TERM])
{
	int i, s;
	gsl_matrix_view mA;
	gsl_vector_view vB;
	gsl_vector *vX;
	gsl_permutation *p;

	mA = gsl_matrix_view_array((double *)A, EMS_FLAT_TERM, EMS_FLAT_TERM);
	vB = gsl_vector_view_array(B, EMS_FLAT_TERM);
	vX = gsl_vector_alloc(EMS_FLAT_TERM);

	p = gsl_permutation_alloc(EMS_FLAT_TERM);
	gsl_linalg_LU_decomp(&mA.matrix, p, &s);
	gsl_linalg_LU_solve(&mA.matrix, p, &vB.vector, vX);

	for ( i=0; i<EMS_FLAT_TERM; i++ )
		B[i] = gsl_vector_get(vX, i);

	gsl_vector_free(vX);
	gsl_permutation_free(p);
}
