#!/bin/csh
limit coredumpsize 0
set working_directory = `pwd`
#
set start = `grep start_process mparameters_run | awk '{print $2}'`
@ prev = $start - 1
set data_input  = `grep data_input mparameters_run | awk '{print $2}'`
set raw_images  = `grep raw_images mparameters_run | awk '{print $2}'`
set radius      = `grep radius mparameters_run | awk '{print $2}'`
set thresh      = `grep thresh_reconst mparameters_run | awk '{print $2}'`
set pbc         = `grep PBC mparameters_run | awk '{print $2}'`
set boff        = `grep BOFF mparameters_run | awk '{print $2}'`
set dang        = `grep DANG mparameters_run | awk '{print $2}'`
set itmax       = `grep ITMAX mparameters_run | awk '{print $2}'`
set mode        = `grep MODE mparameters_run | awk '{print $2}'`
set rrec        = `grep res_reconstruction mparameters_run | awk '{print $2}'`
set rref        = `grep res_refinement mparameters_run | awk '{print $2}'`
set rbf		= `grep RBFACT mparameters_run | awk '{print $2}'`
set sym		= `grep Sym mparameters_run | awk '{print $2}'`
set pix		= `grep pixel_size mparameters_run | awk '{print $2}'`
set kV          = `grep kV mparameters_run | awk '{print $2}'`
set AmpC        = `grep Amp_contrast mparameters_run | awk '{print $2}'`
set mask	= `grep mask mparameters_run | awk '{print $2}'`
set dstep	= `grep dstep mparameters_run | awk '{print $2}'`
set first	= `grep first_particle mparameters_run | awk '{print $2}'`
set last	= `grep last_particle mparameters_run | awk '{print $2}'`
#
\rm ${data_input}_$start.mrc
\rm ${data_input}_$start.res
#
#>& ${data_input}_mreconstruct_$start.log

time /gusr/niko/cluster/frealign_v8.09/bin/frealign_v8_mp.exe << eot 
M,0,F,T,F,F,0,T,T,F,0,F,1					!CFORM,IFLAG,FMAG,FDEF,FASTIG,FPART,IEWALD,FBEAUT,FCREF,FMATCH,IFSC,FSTAT,IBLOW
${radius},220.0,${pix},${AmpC},${mask},${pbc},75.0,100.,20,10	!RO,RI,PSIZE,WGH,XSTD,PBC,BOFF,DANG,ITMAX,IPMAX
1 1 1 1 1							!MASK
${first},${last}						!IFIRST,ILAST 
${sym}     							!ASYM symmetry card (I=icosahedral)
1.0,${dstep},60.0,${thresh},2.0,${kV},0.0,0.0			!RELMAG,DSTEP,TARGET,THRESH,CS,AKV,TX,TY
${rrec},200.0,${rref},100.0,${rbf} 				!RREC,RMAX1,RMAX2,DFSTD,RBFACT
${raw_images}.mrc
/dev/null
${data_input}_$start.par
${data_input}.res
${data_input}_${start}_dummy.shft
0., 0., 0., 0., 0., 0., 0., 0.					! terminator with RELMAG=0.0
${data_input}_${start}.mrc
${data_input}_${start}_weights
${data_input}_${start}_map1.mrc
${data_input}_${start}_map2.mrc
${data_input}_${start}_phasediffs
${data_input}_${start}_pointspread
eot
#
#mv ${data_input}_${start}.mrc ${working_directory}/.
\rm ${data_input}_${start}_weights
\rm ${data_input}_${start}_dummy.shft
\rm ${data_input}_${start}_map1.mrc
\rm ${data_input}_${start}_map2.mrc
\rm ${data_input}_${start}_phasediffs
\rm ${data_input}_${start}_pointspread
#
echo 'finished'
date
#
