      PROGRAM NORMSCAN
C
C	NIKO, 30 OCTOBER 2007
C
      IMPLICIT NONE
C
      INTEGER NXYZ(3),MXYZ(3),MODE,I,J,NX,NY,ID,NN1,CNT
      PARAMETER (NN1=20000)
      REAL DMIN,DMAX,DMEAN,AIN(NN1*NN1),DRMS,ALIN(NN1),F
      REAL DMIN1,DMAX1
      PARAMETER (F=1.3)
      DOUBLE PRECISION SUM1,SUM2
      CHARACTER FILEIN*70,FILEOUT*70
C
      WRITE(6,1000)
1000  FORMAT(/' NORMALIZE ZEISS SCAN, V1.0 (30-Oct-2007)'//,
     +	      ' Input image file name')
      READ(5,1010)FILEIN
1010  FORMAT(A)
      WRITE(6,1010)FILEIN
      WRITE(6,1060)
1060  FORMAT(/' Output normalized image file name')
      READ(5,1010)FILEOUT
      WRITE(6,1010)FILEOUT

      CALL IMOPEN(1,FILEIN,'RO')
      CALL IRDHDR(1,NXYZ,MXYZ,MODE,DMIN,DMAX,DMEAN)
      IF (NXYZ(1)*NXYZ(2).GT.NN1*NN1) THEN
      	WRITE(6,1080)NN1
1080	FORMAT(/' Image dimensions too big, NN1=',I10)
      	STOP
      ENDIF
C
      WRITE(*,1110)NXYZ(1),NXYZ(2)
1110  FORMAT(/,' READING IMAGE...'/' NX, NY= ',2I10)
C
      NX=NXYZ(1)
      NY=NXYZ(2)
      DO 10 I=1,NY
        ID=1+NX*(I-1)
        CALL IRDLIN(1,AIN(ID),*999)
10    CONTINUE
      CALL IMCLOSE(1)
C
      DMIN=9999999999.0
      DMAX=-9999999999.0
      SUM1=0.0D0
      SUM2=0.0D0
      DO 20 I=1,NX*NY
        IF (AIN(I).LT.DMIN) DMIN=AIN(I)
        IF (AIN(I).GT.DMAX) DMAX=AIN(I)
        SUM1=SUM1+AIN(I)
        SUM2=SUM2+AIN(I)**2
20    CONTINUE
      DMEAN=SUM1/NX/NY
      DRMS=SQRT(SUM2/NX/NY-DMEAN**2)
      PRINT *
      PRINT *,'MIN,MAX  = ',DMIN,DMAX
      PRINT *,'MEAN,RMS = ',DMEAN,DRMS
      DMIN1=DMIN
      DMAX1=DMAX
C
      DO 30 I=1,NX
        ALIN(I)=0.0
30    CONTINUE
C
      CNT=0
      DO 40 I=1,NY
        SUM1=0.0D0
        SUM2=0.0D0
        DO 50 J=1,NX
          ID=J+NX*(I-1)
          SUM1=SUM1+AIN(ID)
          SUM2=SUM2+AIN(ID)**2
50      CONTINUE
        SUM1=SUM1/NX
        SUM2=SQRT(SUM2/NX-SUM1**2)
        IF (SUM2.LT.F*DRMS) THEN
          CNT=CNT+1
          DO 60 J=1,NX
            ID=J+NX*(I-1)
            ALIN(J)=ALIN(J)+AIN(ID)
60        CONTINUE
        ENDIF
40    CONTINUE
C
      CNT=0
      SUM1=0.0D0
      SUM2=0.0D0
      DO 70 J=NX/5,4*NX/5
        SUM1=SUM1+ALIN(J)
        SUM2=SUM2+ALIN(J)**2
        CNT=CNT+1
70    CONTINUE
      SUM1=SUM1/CNT
      SUM2=SQRT(SUM2/CNT-SUM1**2)
      DO 80 J=1,NX
        ALIN(J)=ALIN(J)/SUM1
        IF (ALIN(J).GT.F) ALIN(J)=F
        IF (ALIN(J).LT.1.0/F) ALIN(J)=1.0/F
80    CONTINUE
C
      DMIN=9999999999.0
      DMAX=-9999999999.0
      SUM1=0.0D0
      SUM2=0.0D0
      DO 90 I=1,NY
        DO 90 J=1,NX
          ID=J+NX*(I-1)
          AIN(ID)=INT(AIN(ID)/ALIN(J)+0.4999999)
          IF (AIN(ID).LT.DMIN1) AIN(ID)=DMIN1
          IF (AIN(ID).GT.DMAX1) AIN(ID)=DMAX1
          IF (AIN(ID).LT.DMIN) DMIN=AIN(ID)
          IF (AIN(ID).GT.DMAX) DMAX=AIN(ID)
          SUM1=SUM1+AIN(ID)
          SUM2=SUM2+AIN(ID)**2
90    CONTINUE
      DMEAN=SUM1/NX/NY
      DRMS=SQRT(SUM2/NX/NY-DMEAN**2)
      PRINT *
      PRINT *,'After normalization:'
      PRINT *,'MIN,MAX  = ',DMIN,DMAX
      PRINT *,'MEAN,RMS = ',DMEAN,DRMS
C
C      MODE=0
      CALL WRTIMG(FILEOUT,NXYZ,MXYZ,MODE,DMIN,DMAX,DMEAN,AIN)
C
      GOTO 9999
999   STOP 'END-OF-FILE ERROR ON READ'
9999  CONTINUE
      END
C**************************************************************************
      SUBROUTINE WRTIMG(FNAM,NXYZ,MXYZ,MODE,DMIN,DMAX,DMEAN,AOUT)
C**************************************************************************
C
      IMPLICIT NONE
C
      INTEGER I,J,NXYZ(3),MXYZ(3),MODE,ID,NXYZST(3)
      REAL DMIN,DMAX,DMEAN,AOUT(*)
      DOUBLE PRECISION DDMEAN
      CHARACTER FNAM*70,TITLE*80
      DATA TITLE/' OUTPUT IMAGE FROM TUBE_UNBEND'/
C
      WRITE(*,1000)NXYZ(1),NXYZ(2)
1000  FORMAT(/,' WRITING IMAGE...'/' NX, NY= ',2I10)
C
      CALL IMOPEN(2,FNAM,'NEW')
      CALL ITRHDR(2,1)
      CALL IALMOD(2,MODE)
      NXYZST(1)=0
      NXYZST(2)=0
      NXYZST(3)=0
      CALL IALSIZ(2,NXYZ,NXYZST)
      CALL IWRHDR(2,TITLE,1,0.0,0.0,0.0)
      DMIN=1.E10
      DMAX=-1.E10
      DDMEAN=0.0D0
      DO 10 J=1,NXYZ(2)
      	ID=1+NXYZ(1)*(J-1)
      	CALL IWRLIN(2,AOUT(ID))
      	DO 10 I=1,NXYZ(1)
      	  ID=I+NXYZ(1)*(J-1)
      	  DDMEAN=DDMEAN+DBLE(AOUT(ID))
      	  IF (AOUT(ID).LT.DMIN) DMIN=AOUT(ID)
      	  IF (AOUT(ID).GT.DMAX) DMAX=AOUT(ID)
10    CONTINUE
      DMEAN=SNGL(DDMEAN)/NXYZ(1)/NXYZ(2)
      CALL IWRHDR(2,TITLE,-1,DMIN,DMAX,DMEAN)
      CALL IMCLOSE(2)
      WRITE(*,1030)DMIN,DMAX,DMEAN
1030  FORMAT(/,' NEW VALUES:',
     +       /,' DMIN, DMAX, DMEAN      ',3F14.3)
C
      RETURN
      END
