#!/usr/bin/env python
# Python script to read output report from CTFFIND3 and to write defocus and astigmatism data to defocus 
# documentation file. 
# Usage: readmrc.py report [key_number]  > outdoc.dat 
# Provided by the SPIDER image processing system
# --------------------------------------------------------------------------
# Read output report from MRC CTFFIND, print out defocus and other values.
#
# Usage: readmrc.py mrc_report [key_number]  > outdoc.dat
#
# The micrograph number is obtained from the report filename (e.g., report003).
# The doc file key may be given as an optional 2nd argument. If none
# is given, the micrograph number is used as the key.
# 
# Output: 6 columns
#  key        mic no.  avg defocus  defocus1    defocus2   angle   astig
#   13 6      13.000   26404.675   26446.720   26362.630   0.940   0.013
# --------------------------------------------------------------------------

import sys
import string
import re

re_filenum = re.compile('[0-9]+$')

def get_mic_number(s):
    a = string.rfind(s, '.')   # remove extension
    if a > -1:
        s = s[:a]
    m = re_filenum.search(s)
    b = m.span()
    i = string.atoi(s[b[0]:b[1]])
    return i

nargs = len(sys.argv[1:])

if nargs == 0:
    print "Usage: readmrc.py mrc_report [key]"
    sys.exit(0)
if nargs > 0:
    report = sys.argv[1]
    mic = get_mic_number(report)
if nargs > 1:
    key = string.atoi(sys.argv[2])
else:
    key = mic

fp = open(report)
B = fp.readlines()
fp.close

for line in B:
    if string.find(line, "Final Values") > -1: break

s = string.split(line)
d1 = string.atof(s[0])
d2 = string.atof(s[1])
davg = (d1 + d2) / 2.0
angle = string.atof(s[2])
astig = string.atof(s[3])
nitems = 6

print "%5d%2d%12.3f%12.3f%12.3f%12.3f%12.3f%12.3f" % (key, nitems, mic, davg, d1, d2, angle, astig)
