#!/bin/csh -f

set micrographs = $1
set ctf = $2
set box = $3
set parfile = $4

if ($1 == "" || $2 == "" || $3 == "" || $4 == "") then
  echo ""
  echo -n "Input root name for CTFFIND4 result and boxer files?"
  echo ""
  set micrographs = $<
  echo $micrographs
  echo ""
  echo -n "Input file extension for CTFFIND4 result files?"
  echo ""
  set ctf = $<
  echo $ctf
  echo ""
  echo -n "Input file extension for boxer files?"
  echo ""
  set box = $<
  echo $box
  echo ""
  echo -n "Output Frealign par file?"
  echo ""
  set parfile = $<
  echo $parfile
endif

rm $parfile
set film = 1

foreach log (`ls ${micrographs}*.${ctf}`)
  set count = `wc -l ${log:r}.${box} | awk '{print $1}'`
  tail -1 $log | awk '{for (i=0; i<'$count'; i++) printf "%10s %10s %10s %10s\n",'$film',$2,$3,$4}' >> $parfile
  @ film++
end
