//	James Z. Chen
//	January 1, 2005
//	All rights reserved

#ifndef __PARAMETER_H
#define __PARAMETER_H 1

#include "platform.h"

// VERSION Identification
#define EMS_VERSION		"V1.0"	// version ID
#define EMS_VLENGTH		8		// storage space

// directory definition
#define EMS_DIR_MCRGRAPH	"micrograph"
#define EMS_DIR_TEMPLATE	"template"
#define EMS_DIR_ATSCREEN	"screening"
#define EMS_DIR_PARTICLE	"particles"

// system running mode
#define EMS_GUI_MODE	1	// interactive mode
#define EMS_COM_MODE	2	// computing mode

// architecture property
#define EMS_ARCH_ENDIN	1		// machine endian property
#define EMS_HEADER		1024	// PRJ header size (bytes)

// for batch processing
#define EMS_PRJ_SCREEN	1

// graphics mode (2D/3D)
#define EMS_GRAPHX_2D	2

// SIGNATURE boolens
#define EMS_TRUE		1
#define EMS_FALSE		0
#define EMS_BUSY		1
#define EMS_FREE		0

// selection flags
#define EMS_SEL_NON		0	// non-particle
#define EMS_SEL_COM		1	// algorithm selection
#define EMS_SEL_MAN		2	// manual selection
#define EMS_SEL_OUI		3	// confirmed selection

// texture map dimension
#define EMS_FILM_TEX	EMS_GXTEX	// micrograph display
#define EMS_TEMP_TEX	128		// template montage display
#define EMS_RFED_TEX	256		// selected reference editing

// for overflow protection
#define EMS_ZERO		0.00001f

// maximum characters for message display
#define LINE_MAX		1024

// maximum characters for project filenames
#define NAMESIZE		1024

// headers for system files
#define EMS_PREFER_H	"EMS parameter preference"
#define EMS_PARTIC_H	"EMS particle selection"

// default filenames
#define EMS_PRJ_FN		" "
#define EMS_PRJ_DR		"."

// default downsize factor
#define EMS_DOWNSIZE	4

// minimum template size (pixel)
#define EMS_TEMP_MIN	32

// default variance box size
#define EMS_VARIABOX	40

// default particle size (A)
#define EMS_PRTK_SIZE	120.0
#define EMS_PRTK_HALF	0.55
#define EMS_FRAME_SIZE	80

// default particle boundary distance (A)
#define EMS_PRTK_DIST	30.0

// default pixel size (A)
#define EMS_PIXEL_SIZE	3.5f

// default LCF mask radius
#define EMS_LCF_MASKR	0.75f

// default SCF mask radius
#define EMS_SCF_MASKR	0.75f
#define EMS_SCF_MASKC	0.15f

// histogram dimension and color scheme
#define EMS_SPEC_MODE	1		// display power spectrum
#define EMS_HSTG_MODE	2		// display intensity histogram
#define EMS_INFO_WIN	156		// height of peak
#define EMS_INFO_BIN	128		// number of bins in histogram
#define EMS_INFO_EXT	2		// margin in histogram to be ignored
#define EMS_SPEC_SIZE	256		// image size for spectrum display
#define EMS_SPEC_SMOT	3		// box size for spectrum smoothing
#define EMS_INFO_BKGD	128		// background color
#define EMS_HSTG_R		16		// RGB color
#define EMS_HSTG_G		0
#define EMS_HSTG_B		64

// display intensity parameters
#define EMS_BRIGHTNESS	0.5		// image brightness
#define EMS_CONTRAST	0.5		// image contrast
#define EMS_HSTG_SIGMA	8		// maximum intensity range (in s.t.d)
#define EMS_SPEC_SIGMA	2		// for spectra display contrast

// default thresholding levels
#define EMS_LCF_THRES	0.50
#define EMS_SCF_THRES	0.50
#define EMS_DCF_THRES	0.25

// default auto/manual masking parameters
#define EMS_EDGE_EXCU	20		// in pixel
#define EMS_VAR_HI		1.3		// high variance threshold
#define EMS_VAR_LO		0.5		// low variance threshold
#define EMS_BRUSH		16		// paint brush size
#define EMS_PENCL		4		// line drawing width
#define EMS_MINIR		10		// minimum circle radius
#define EMS_LINES		1		// operation line drawing
#define EMS_CIRCLE		2		// operation circle drawing
#define EMS_PAINT		3		// operation mask painting
#define EMS_ERASE		4		// operation mask erasing

// FFT parameters
#define FWD_FFT			+1
#define INV_FFT			-1
#define FWD_SCALE		 0
#define INV_SCALE		-1

// conversion from degree to radian
#define DEG2RAD			0.01745f
#define RAD2DEG			57.2958f

// GL image/label display depth
#define EMS_INF_DEPTH	20
#define EMS_FILM_GLD	10
#define EMS_MASK_GLD	9
#define EMS_LINE_GLD	8.5
#define EMS_PEAK_GLD	8
#define EMS_TEMP_GLD	10
#define EMS_LABL_GLD	9
#define EMS_ZOOM_GLD	7
#define EMS_MARK_GLD	7
#define EMS_FILA_GLD	8
#define EMS_SELC_GLD	9.5
#define EMS_DGEL_GLD	10
#define EMS_CHRT_GLD	10

// selection marker parameters
#define EMS_MARK_SIZE	4
#define EMS_MARK_LINE	1
#define EMS_MKCOM_R		1.0
#define EMS_MKCOM_G		0.0
#define EMS_MKCOM_B		0.0
#define EMS_MKMAN_R		0.0
#define EMS_MKMAN_G		0.0
#define EMS_MKMAN_B		1.0
#define EMS_MKOUI_R		0.0
#define EMS_MKOUI_G		1.0
#define EMS_MKOUI_B		0.0

// inspection focus parameters
#define EMS_FOCUS_RAD	1.7
#define EMS_FOCUS_LINE	1
#define EMS_FOCUS_R		0.8
#define EMS_FOCUS_G		0.0
#define EMS_FOCUS_B		0.8
#define EMS_CROSS_BAR	0.3
#define EMS_CROSS_R		0
#define EMS_CROSS_G		255
#define EMS_CROSS_B		0
#define EMS_BOUND_BAR	0.2
#define EMS_BOUND_R		255
#define EMS_BOUND_G		255
#define EMS_BOUND_B		0

// window background color
#define EMS_BKG_R		0.0
#define EMS_BKG_G		0.0
#define	EMS_BKG_B		0.0

// micrograph mask color
#define EMS_MSK_R		255
#define EMS_MSK_G		128
#define EMS_MSK_B		0
#define EMS_MSK_A		255
#define EMS_MSK_BGD		0
#define EMS_MSKLN_R		0.0
#define EMS_MSKLN_G		1.0
#define EMS_MSKLN_B		0.0

// for rotational search
#define EMS_ROTA_RANGE	360
#define EMS_ROTA_DELTA	15
#define EMS_ROTA_AVERG	3

// zoom scaling parameters
#define EMS_ZSCALE		0.005
#define EMS_Z0_LIM		0.25
#define EMS_Z1_LIM		1.00

// magnifier box size (in particle diameter)
#define EMS_ZOOMSIZE	4

// DP GUI operation modes
#define DP_MCRGRAPH_MODE	1
#define DP_TEMPLATE_MODE	2
#define DP_PARTICLE_MODE	3
#define DP_2DMIMAGE_MODE	4

// FUNCTION GUI operation modes
#define DP_FUNCIMAG_MODE	201
#define DP_FUNCDGEL_MODE	202
#define DP_FUNCALGN_MODE	203

// expansion for power-spec calculation
#define EMS_TMP_EXP		2

// distance tolerance for particle deletion (in pixel)
#define EMS_DST_TOLERANCE	5

// search radius (of particle diameter) for DCF local maximum
#define EMS_DCF_RADIUS		0.75

// gap between montage in TEMPLATE display
#define EMS_TEMP_GAP		4
#define EMS_TEMP_MSKR		0
#define EMS_TEMP_MSKG		0
#define EMS_TEMP_MSKB		96

// monitor display parameters
#define EMS_MONTR_SIZE		120
#define EMS_MONFX_SIZE		250
#define EMS_MONFY_SIZE		250
#define EMS_MONTR_BLUE		64
#define EMS_MON_RESZ1		2
#define EMS_MON_RESZ2		1
#define EMS_MON_RESZ3		1
#define EMS_MON_BLUR1		1
#define EMS_MON_BLUR2		2
#define EMS_RESZ_MAX		32
#define EMS_BLUR_MAX		32

// image quality marker
#define EMS_FILM_MARKER		64
#define EMS_MARKER_SIZE		16

// filament recognition
#define EMS_FILA_DIAM		100.0	// default filament diameter (A)
#define EMS_FILA_UNIT		100.0	// default filament segment length (A)
#define EMS_FILA_CROX		0.0		// default filament segment overlap (A)
#define EMS_FILA_BRDG		0.75	// marching stepsize relative to segment length
#define EMS_FILA_BEND		0.50	// bending tolerance between adjacent segments
#define EMS_MAX_BEND		30		// maximum bending angle between adjacent segments
#define EMS_FILA_ROTA		3		// rotational search interval (degree)
#define EMS_FILA_MAXM		32		// the maximum number of filaments, should be removed
#define EMS_FILA_LENG		128		// the maximum length of a filament, should be removed
#define EMS_FILA_LINE		2		// filament axis drawing line width
#define EMS_AXIS_R			1.0		// filament axis drawing color
#define EMS_AXIS_G			1.0
#define EMS_AXIS_B			0.0
#define EMS_FILA_R			0.0		// filament trace drawing color
#define EMS_FILA_G			0.0
#define EMS_FILA_B			1.0

// image pre-processing
#define EMS_L_PASS			(2*EMS_PIXEL_SIZE)
#define EMS_H_PASS			1000.0	// low/high band limit in Angstrom
#define EMS_BAND_HSFT		0.05	// soft edge on low frequency side
#define EMS_BAND_LSFT		0.10	// soft edge on high frequency side
#define EMS_FLAT_TILE		16		// maximum tiles along each dimension (2D)
#define EMS_AREA_THRES		0.7		// minimum unmasked area in each tile
#define EMS_PIX_BIN			2		// image pixel binning
#define EMS_CLIP_MAX		1000.0	// max/min histogram clipping

// image stack display
#define EMS_QUAL_NORM		1		// image display quality index
#define EMS_QUAL_GOOD		2
#define EMS_QUAL_HIGH		3
#define EMS_TEX_NORM		64		// texture map size for image display
#define EMS_TEX_GOOD		128
#define EMS_TEX_HIGH		256
#define EMS_STACK_GAP		2		// gap between image frames
#define EMS_FRAME_SELC		0.7		// frame highlight transparency
#define EMS_FRAME_CROP		80		// frame resize

// template masking
#define EMS_MASK_L1			1
#define EMS_MASK_L2			2

// digital gel filtration
#define EMS_GEL_RANGE		5		// multiple of mass s.t.d. (+/-)
#define EMS_GEL_BIN			(4*EMS_GEL_RANGE+1)	// historgram bins
#define EMS_GEL_BINPIX		50		// bin display length in pixel
#define	EMS_GEL_VERTIC		500		// length of the vertical axis
#define EMS_GEL_RADIUS		0.7f	// density "mass" masking radius
#define EMS_GEL_PICK		10		// picking tolerance (pixel)

// image processing functions
#define EMS_OPT_NORMAL		1		// image frame normalization
#define EMS_OPT_ROTAVE		2		// rotational average of each frame
#define EMS_OPT_ROTSUM		3		// rotational sum of all frames
#define EMS_OPT_SUMALL		4		// pixel-wise frame summation
#define EMS_OPT_INVERT		5		// invert micrograph contrast
#define EMS_OPT_FLATEN		6		// micrograph background removal
#define EMS_OPT_ISCALE		7		// intensity scaling
#define EMS_OPT_FILTER		8		// band-pass filtering
#define EMS_OPT_RESIZE		9		// image frame resize
#define EMS_OPT_SAMPLE		10		// image resampling
#define EMS_OPT_PIXBIN		11		// pixel binning
#define EMS_OPT_HFLIP		12		// image flip (X)
#define EMS_OPT_VFLIP		13		// image flip (Y)
#define EMS_OPT_MIRROR		14		// density mirroring
#define EMS_OPT_HSCLIP		15		// histogram clipping

// particle alignment & classification
#define EMS_CLS_RADIUS		0.7		// particle masking radius
#define EMS_ALN_CORREL		0.5		// template correlation threshold
#define EMS_ALN_SHIFT		0.3		// particle off-center tolerance
#define EMS_ALN_PHASE		70.0	// phase residual threshold

// model density display color
#define EMS_DENSITY_R		0.9f
#define EMS_DENSITY_G		0.5f
#define EMS_DENSITY_B		0.0f
#define EMS_DENSITY_A		0.5f

// model density viewer
#define EMS_VIEW_POS		1000.0	// eye position
#define EMS_MODEL_SURF		1		// surface model
#define EMS_MODEL_MESH		2		// mesh model
#define EMS_MODEL_CROP		100		// model cropping size
#define EMS_HST3_BIN0		0.0f	// histogram starting value
#define EMS_HST3_BIN1		3.0f	// histogram ending value
#define EMS_LEVEL_SET		2		// initial levels
#define EMS_LEVEL_MAX		16		// maximal contour levels


#endif
