//	James Z. Chen
//	January 1, 2005
//	All rights reserved

#ifndef __CPANEL_H
#define __CPANEL_H 1

#include "/usr/include/stdio.h"
#include "/usr/include/stdlib.h"
#include "../signature/include/FL/Fl_Bitmap.H"


class EMS_Panel {
private:
	int resz1, resz2;		// resize parameter for monitor 1 & 2 (PARTICLE)
	int blur1, blur2;		// blurring parameter for monitor 1 & 2
	int resz3;				// resize parameter for monitor 3 (FILAMENT)

	// for monitor image display
	unsigned char *mon1Img, *mon2Img;	// in PARTICLE page
	Fl_RGB_Image *mon1rgb, *mon2rgb;
	unsigned char *mon3Img;				// in FILAMENT page
	Fl_RGB_Image *mon3rgb;

	// store histogram/spectrum Fl_RGB map
	unsigned char *inf_Img;				// in MICROGRAPH page
	Fl_RGB_Image *inf_rgb;

public:
	EMS_Panel();
	~EMS_Panel();

	// setup monitor display
	void monitorPrtk(void);
	void monitorFila(float *filaImg, int length, int width);
	void monitorSpec(void);
	void monitorTemp(int n);
	void redrawTemp(void);
	void redrawSpec(void);
	void redrawFocus(void);
	void clearMonitor(void);

	void setResz1(int factor) { resz1=factor; };
	void setResz2(int factor) { resz2=factor; };
	void setBlur1(int factor) { blur1=factor; };
	void setBlur2(int factor) { blur2=factor; };
	void setResz3(int factor) { resz3=factor; };

	int  getResz1(void) { return(resz1); };
	int  getResz2(void) { return(resz2); };
	int  getBlur1(void) { return(blur1); };
	int  getBlur2(void) { return(blur2); };
	int  getResz3(void) { return(resz3); };

	// generate and draw micrograph intensity histogram
	void drawImgInfo(char flagRerun);
	void clearImgInfo(void);

	// display project parameters at GUI
	void displayParam(void);
};


extern EMS_Panel *cPanel;


#endif
