//	James Z. Chen
//	January 1, 2005
//	All rights reserved

#include "misc.h"
#include "gui.h"
#include "project.h"
#include "../signature/include/FL/fl_ask.H"
#include "platform.h"


extern DisplayPanel_UI *EMS_DP;
char message[LINE_MAX];


void errReport(char *err)
{
	switch ( emsRunMode ) {

	case EMS_GUI_MODE:
		EMS_DP->msgBoard->textcolor(FL_RED);
		EMS_DP->msgBoard->value(err);
		Fl::flush();
		fl_alert(err);
		break;

	case EMS_COM_MODE:
		printf("Error: %s\n", err);
		exit(1);
		break;
	}
}


void msgReport(char *msg)
{
	switch ( emsRunMode ) {
		
	case EMS_GUI_MODE:
		EMS_DP->msgBoard->textcolor(FL_YELLOW);
		EMS_DP->msgBoard->value(msg);
		Fl::flush();
		break;
		
	case EMS_COM_MODE:
		printf("%s\n", msg);
		break;
	}
}


void askSaveProj(void)
{
	if ( project->projSaveStatus == EMS_FALSE ) {
		fl_beep(FL_BEEP_MESSAGE);
		if ( fl_ask("Save the current project?") )
			saveProject_CB();
		else
			project->projSaveStatus = EMS_TRUE;
	}
}


char makeDirectory(char *dirName)
{
	char comdline[LINE_MAX];

#ifdef EMS_OS_WIN
	sprintf(comdline, "md \"%s\"", dirName);
#endif

#ifdef EMS_OS_LNX
	sprintf(comdline, "mkdir \"%s\"", dirName);
#endif

#ifdef EMS_OS_MAC
	sprintf(comdline, "mkdir \"%s\"", dirName);
#endif

	system(comdline);
	return(EMS_TRUE);
}


void systemStatus(char status)
{
	if ( status == EMS_BUSY )
		EMS_DP->indicator->activate();
	else
		EMS_DP->indicator->deactivate();
	
	Fl::flush();
}


void simpleFilePath(char *fileName)
{
	int i, j, leng, nslash=0;

	leng = strlen(fileName);
	if ( leng <= 16 ) return;

	for ( i=0; i<leng; i++ ) {
		if ( (fileName[i]=='/') || (fileName[i]=='\\') )
			nslash ++;
	}

	// no need for abrievation
	if ( nslash < 3 ) return;

	// only display the immediate parent directory
	for ( i=0; i<leng; i++ ) {
		if ( (fileName[i]=='/') || (fileName[i]=='\\') ) {
			nslash --;

			if ( (nslash==1) && (i>2) ) {
				fileName[0] = fileName[1] = fileName[2] = '.';
				
				for ( j=3; j<(leng-i+3); j++ )
					fileName[j] = fileName[i+j-3];

				fileName[j] = '\0';
				break;
			}
		}
	}
}


void getFilePath(char *file_name, char *pathName, char *fileName)
{
	int i, index, nameSize;
	
	index = 0;
	nameSize = strlen(file_name);
	
	// get file-name
	for ( i=0; i<nameSize; i++ ) {
		if ( (file_name[i]=='/') || (file_name[i]=='\\') ) {
			index = i + 1;
			fileName[0] = '\0';
			continue;
		}
		else {
			fileName[i-index] = file_name[i];
			fileName[i-index+1] = '\0';
		}
	}

	// get path-name
	strcpy(pathName, file_name);
	pathName[index-1] = '\0';
}


void removeExt(char *file_name, char *ext_name)
{
	int nameSize, extSize;

	extSize = strlen(ext_name);
	nameSize = strlen(file_name) - extSize;

	if ( nameSize <= 0 )
		return;
	else if ( !strncmp(file_name+nameSize, ext_name, extSize) )
		file_name[nameSize] = '\0';
}


long fileSize(FILE *fp)
{
  long fsize;

  fseek(fp, 0, SEEK_END);
  fsize = ftell(fp);
  rewind(fp);

  return(fsize);
}
