//	James Z. Chen
//	January 1, 2005
//	All rights reserved

#ifndef __INTERACT_H
#define __INTERACT_H 1

#include "/usr/include/stdio.h"
#include "/usr/include/stdlib.h"
#include "parameter.h"
#include "project.h"


// system status control
void setDPMode_CB(int mode);
void setImgBright_CB(float value);
void setImgContrast_CB(float value);
void setImgInfoMode_CB(void);
void setMaskStatus_CB(void);
void setPrtkStatus_CB(void);
void setZoomStatus_CB(void);
void linesMask_CB(void);
void circleMask_CB(void);
void paintMask_CB(void);
void eraseMask_CB(void);

// MENUBAR functions
void EMS_Login_CB(char flagLogin);
void EMS_Exit_CB(void);
void newProjSpace_CB(void);
void loadProjSpace_CB(void);
void loadProject_CB(void);
void saveProject_CB(void);
void saveProjectAs_CB(void);
void clearProject_CB(void);
void clearParticle_CB(void);
void loadParticlePTK_CB(void);
void loadParticlePLT_CB(void);
void loadParticleSPD_CB(void);
void saveParticlePTK_CB(void);
void saveParticleMRC_CB(void);
void saveParticlePLT_CB(void);
void saveParticleSPD_CB(void);
void saveImageCrop_CB(void);
void EMS_Docum_CB(void);
void EMS_About_CB(void);

// MICROGRAPH page
void loadMcrgraph_CB(void);
void loadMcrgraphSPD_CB(void);
void loadMcrgraphTIF_CB(void);
void saveMcrgraph_CB(void);
void clearMcrgraph_CB(void);
void setPixSize_CB(double value);
void setVariaBox_CB(int value);
void setEdgeExcu_CB(int value);
void setSpecSize_CB(int value);
void setFilmMarker_CB(void);
void setVarHi_CB(float value);
void setVarLo_CB(float value);
void autoMasking_CB(void);
void setBrushSize_CB(int value);
void setMaskTrans_CB(unsigned char value);
void clearMasking_CB(void);
void setSpecBright_CB(float value);
void setSpecContrast_CB(float value);
void imageRestore_CB(void);

// TEMPLATE page
void loadTemplate_CB(void);
void focusTemplate_CB(int tid);
void clearTemplate_CB(void);
void setRotatFlag_CB(void);
void setRotaRange_CB(float value);
void setRotaDelta_CB(float value);
void setLCFmask_CB(float value);
void setSCFmask_CB(float value);
void setSCFcent_CB(float value);
void appProfileMask_CB(void);
void setTempFrame_CB(double value);
void setTempInclude_CB(void);
void setIncExcAll_CB(char status);
void setMaskLevel_CB(char value);
void editTempMask_CB(char status);
void syncTempMask_CB(void);
void clearTempMask_CB(void);
void setL2Mask_CB(void);

// PARTICLES page
void testSignature_CB(void);
void calcSignature_CB(void);
void setDownSize_CB(int value);
void setPrtkSize_CB(double value);
void setFrameSize_CB(int value);
void setLCFthres_CB(double value);
void setSCFthres_CB(double value);
void setDSTthres_CB(double value);
void inspectAccept_CB(void);
void inspectReject_CB(void);
void inspectUndo_CB(void);
void setMon1Resz_CB(int value);
void setMon2Resz_CB(int value);
void setMon1Blur_CB(int value);
void setMon2Blur_CB(int value);
void setMon1Cross_CB(void);
void setMon2Cross_CB(void);
void setSpecView_CB(void);
void setRefrView_CB(void);
void setMonBright_CB(double value);
void setMonContrast_CB(double value);
void gotoStackEditor_CB(void);

// function: 2D IMAGE page
void findSegment_CB(void);
void traceFilament_CB(void);
void setDCFthres_CB(double value);
void setFilaBridge_CB(double value);
void setFilaBend_CB(double value);
void setFilaBright_CB(double value);
void setFilaContrast_CB(double value);
void setMon3Resz_CB(int value);
void setMon3Cross_CB(void);
void setCropMode_CB(void);
void setFilaDiameter_CB(double value);
void setSegmtLeng_CB(double value);
void setSegmtCrox_CB(double value);
void setFilaShiftX_CB(double value);
void setFilaShiftY_CB(double value);
void setFilaExtnX_CB(double value);
void setFilaExtnY_CB(double value);
void setFilaRotate_CB(double value);
void setFilaAve_CB(void);
void clearFilaTemp_CB(void);
void applyImageProc_CB(int opt);

// function: Image Stack Editor
void loadImageStack_CB(void);
void saveImageStack_CB(void);
void closeImageStack_CB(void);
void appendImageStack_CB(void);
void setDisplayFrame_CB(int f0);
void setDispQuality_CB(int quality);
void dispImageStack_CB(void);
void setFrameStart_CB(void);
void setFrameBack_CB(void);
void setFrameFore_CB(void);
void setFrameEnd_CB(void);
void setLabelDisplay_CB(void);
void setFrameScale_CB(int val);
void clearImgSelect_CB(void);
void extractImgSelect_CB(void);
void deleteImgSelect_CB(void);
void applyStackProc_CB(int opt);

// function: Digital Gel Filtration
void setGelMassRad_CB(double val);
void gelMassStat_CB(void);
void gelFiltrate_CB(void);
void setGelLmass_CB(double mass);
void setGelHmass_CB(double mass);
void gelCommit_CB(void);

#endif
