//	James Z. Chen
//	January 1, 2005
//	All rights reserved

#ifndef __IMAGES_H
#define __IMAGES_H 1

#include "/usr/include/stdio.h"
#include "/usr/include/stdlib.h"
#include "parameter.h"
#include "maps.h"

// histogram display parameters
#define EMS_CC_BIN			21		// for correlation histogram display
#define EMS_CC_BASE_X0		-300	// starting position of X-axis
#define EMS_CC_BASE_X1		-50		// ending position of X-axis
#define EMS_CC_BASE_Y0		100		// starting position of Y-axis
#define EMS_CC_BASE_Y1		-100	// ending position of Y-axis
#define EMS_CC_TICK			25		// tick marker on X-axes

#define EMS_PHASE_LOW		40.0	// min. in phase residual chart
#define EMS_PHASE_STP		10.0	// step size in phase residual chart

#define EMS_DX_BIN			21		// for shift histogram display
#define EMS_DX_BASE_X0		50		// starting position of X-axis
#define EMS_DX_BASE_X1		300		// ending position of X-axis
#define EMS_DX_BASE_Y0		100		// starting position of Y-axis
#define EMS_DX_BASE_Y1		-100	// ending position of Y-axis
#define EMS_DX_TICK			25		// tick marker on X-axes

// particle alignment
#define EMS_PRECISION		10.0	// automatic precision setting
#define EMS_SOFT_MASK		5		// particle soft-mask in pixels


// particle property (individual frame in stack)
struct EMS_PTKPAR {
	char  select;	// EMS_TRUE for selected frame
	int   x0, y0;	// coordinates in micrograph
	float dx, dy;	// alignment shift (x, y)
	float shift;	// shift from image frame center
	float eulA;		// euler angles (eulA is in-plane rotation)
	float eulB, eulG;
	float score;	// best alignment DCF score
	int   tmpid;	// template ID associated with "score"

	float df1, df2;	// defocus parameters
	float stigma;	// stigmation angle
};


// alignment project header parameters
struct EMS_ALNPAR {
	char  version[EMS_VLENGTH];
	int   endin;
	int   imgX, imgY, imgN;	// image dimensions & frames
	float precision;		// particle alignment precision (degree)

	// reserved for future use
	char  unused[EMS_HEADER - EMS_VLENGTH - 20];
};


class EMS_Images {
public:
	struct EMS_ALNPAR param;	// core parameter set
	char stackName[NAMESIZE];	// absolute image stack filename
	char imgsName[NAMESIZE];	// filename itself (w/o extension)
	char parInName[NAMESIZE];	// FREALIGN PAR input filename
//	MRC_MAP imgAlign;		// aligned particle image frames
	MRC_MAP imgStack;		// particle image frames
	int frame0, frame1;		// starting / ending frame to be displayed
	float imgBrit;			// brightness ctrl of image
	float imgCntr;			// contrast ctrl of image
	int textSize;			// texture map size
	int frameSize;			// image frame pixels
	int pageSize;			// image frames in one page
	int imgScale;			// image frame display scale
	int selCount;			// selection count
	char flagSaved;			// EMS_TRUE for saved stack (after modification)
	char labelDisp;			// EMS_TRUE for frame ID display

	// image processing
	double lowPass;			// band-pass filtering
	double highPass;
	double frameMult;		// intensity scaling (k*I+c)
	double frameAddt;
	int cropX, cropY;		// image dimensions after cropping
	float clipMin, clipMax;	// intensity clipping thresholds

	// digital gel filtration
	float gelMassRad;		// disc radius for mass evaluation
	float gelMassMin;		// min. mass of the stack
	float gelMassMax;		// max. mass of the stack
	float gelMassAve;		// ave. mass of the stack
	float gelMassStd;		// std. mass of the stack
	int   gelCount;			// particle selection from gel
	float *gelMass;			// individual particle "mass"
	char  *gelSelect;		// EMS_TRUE for gel selection
	float gelLmass;			// low-end threshold
	float gelHmass;			// high-end threshold
	int   gelHist[EMS_GEL_BIN];	// histogram bins
	int   gelBinMax;		// max. cases in one bin

	// particle alignment
	struct EMS_PTKPAR *attrib;	// attribute of each particle frame
	struct EMS_PTKPAR *attrb2;	// for extract/delete operation
	char   flagAlign;		// EMS_TRUE for particle alignment done
	char   flagClass;		// EMS_TRUE for particle classification done
	char   flagSync;		// EMS_TRUE for already synchronized with alignment
	char   flagMask;		// EMS_TRUE for masking frames for output
	char   flagRota;		// EMS_TRUE for rotating frames for output
	char   flagFrealign;	// EMS_TRUE for Frealign statistics
	double maskRadius;		// particle masking radius for alignment and classification
	double corrThres;		// template correlation threshold
	double shiftThres;		// alignment shift tolerance
	double phaseThres;		// FREALIGN phase residual threshold
	double falgnThres;		// FREALIGN alignment shift threshold
	int dxHist[EMS_DX_BIN];	// for shift histogram display
	int dxBinMax;			// max. count in one bin
	int ccHist[EMS_CC_BIN];	// for correlation histogram display
	int ccBinMax;			// max. count in one bin
	int alignCount;			// particles with good alignment

	EMS_Images();
	~EMS_Images();

	// image stack editor
	char loadImageStack(char *fileName);
	char appendImageStack(char *fileName);
	char saveImageStack(char *fileName);
	char clearImageStack(void);
	void paramDisplay(void);
	void setDispFrames(int frameID);
	void browseFrames(char instruct);
	void clearSelect(void);
	char extractFrames(char &flagSync);
	char deleteFrames(char &flagSync);
	char syncPrtkSelect(char status);
	void setNewStack(float *buffer, char flagNewStack);

	// project management
	void resetParam(void);

	// image processing functions
	char filtImageStack(void);
	char normImageStack(void);
	char scalImageStack(void);
	char clipImageStack(void);
	char cropImageStack(void);
	char imgPixBin(void);
	char imgResample(void);
	char imgRotaSum(void);
	char imgRotaAve(void);
	char imgSumAll(void);

	// digital gel filtration
	inline void resetGelThres(void);
	void setGelLmass(double mass);
	void setGelHmass(double mass);
	char calcGelMass(void);
	char gelFiltration(void);
	char gelCommit(void);
};


extern EMS_Images *functImage;


#endif
