//	James Z. Chen
//	January 1, 2005
//	All rights reserved

#include "../signature/include/FL/glut.H"

#include "platform.h"

#include "/usr/include/GL/glu.h"

#include "/usr/include/stdio.h"
#include "gui.h"
#include "gltext.h"


extern DisplayPanel_UI *EMS_DP;
void *CurrentFont = GLUT_BITMAP_9_BY_15;
int FontHeights[] = { 13, 15, 10, 24, 10, 12, 18 };

void *Fonts[] = { GLUT_BITMAP_8_BY_13, 
                  GLUT_BITMAP_9_BY_15,
                  GLUT_BITMAP_TIMES_ROMAN_10, 
                  GLUT_BITMAP_TIMES_ROMAN_24,
                  GLUT_BITMAP_HELVETICA_10, 
                  GLUT_BITMAP_HELVETICA_12,
                  GLUT_BITMAP_HELVETICA_18 };


inline void* GetCurrentFont(void)
{
	return(CurrentFont);
}


inline void SetCurrentFont(void *font)
{
	CurrentFont=font;
}


inline void SetCurrentFont(int fontid)
{
	CurrentFont=Fonts[fontid];
}


inline int GetFontHeight(void *font)
{
	if ( font == GLUT_BITMAP_8_BY_13 )
		return(13);
	else if ( font == GLUT_BITMAP_9_BY_15 )
		return(15);
	else if ( font == GLUT_BITMAP_TIMES_ROMAN_10 )
		return(10);
	else if ( font == GLUT_BITMAP_TIMES_ROMAN_24 )
		return(24);
	else if ( font == GLUT_BITMAP_HELVETICA_10 )
		return(10);
	else if ( font == GLUT_BITMAP_HELVETICA_12 )
		return(12);
	else if ( font == GLUT_BITMAP_HELVETICA_18 )
		return(18);
	else
		printf("ERROR (Text): Not a valid font!\n"); 

	return(0);
}


inline int GetFontHeight(void)
{ 
	return( GetFontHeight(CurrentFont) ); 
}


inline int GetFontHeight(int fontid)
{
	return( FontHeights[fontid] );
}


void setLabel(int x, int y, char *buffer)
{
	int FontHeight = GetFontHeight(CurrentFont);
	int winX = EMS_DP->imgDisplay->w();
	int winY = EMS_DP->imgDisplay->h();

	if ( x<0 || x>=winX || y<0 || y>=winY ) return;

	glPushAttrib(GL_LIGHTING_BIT);
    glDisable(GL_LIGHTING);
    glDisable(GL_COLOR_MATERIAL);
	glPushAttrib(GL_COLOR_BUFFER_BIT);
    glDisable(GL_DITHER);     
	glPushAttrib(GL_DEPTH_BUFFER_BIT);
    glDisable(GL_DEPTH_TEST);
	
	glPushAttrib(GL_VIEWPORT_BIT);
	glViewport(0, 0, winX, winY);
	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
    glLoadIdentity();
	gluOrtho2D(0, winX-1, 0, winY-1);
	glMatrixMode(GL_MODELVIEW);
	glPushMatrix();
    glLoadIdentity();

	glRasterPos2i(x, y);

	for ( char *p=buffer; *p; p++ ) {
		
		if ( *p == '\n' ) {
			if ( x>=0 && y>=0 ) {
				y -= FontHeight;
				glRasterPos2i(x, y);
			}
		}
		else {
			glutBitmapCharacter(CurrentFont,*p);
		}

		glMatrixMode(GL_PROJECTION);
		glPopMatrix();
		glMatrixMode(GL_MODELVIEW);
		glPopMatrix();
		glPopAttrib();
		glPopAttrib();
		glPopAttrib();
		glPopAttrib();
	}
}
