//	James Z. Chen
//	January 1, 2005
//	All rights reserved

#include "project.h"
#include "panel.h"
#include "misc.h"
#include "fftn.h"
#include "gui.h"


extern DisplayPanel_UI *EMS_DP;


// input parameters are in micrograph.density[] coordinates
void EMS_Project::setFilaModel(int x0, int y0, int x1, int y1, char flagInit)
{
	int x, y, dimX, dimY;
	double xc, yc, xf, yf, cosAng, sinAng;
	double filaXt, filaYt, filaRt, dA, dB, dC, dD, dE, dF;
	int filaLt, filaWt, xm, ym, xp, yp;
	float *filaImg;

	if ( micrograph.exist == EMS_FALSE ) return;

	systemStatus(EMS_BUSY);

	if ( flagInit ) {
		filaX = (x0 + x1) / 2.0;
		filaY = (y0 + y1) / 2.0;

		if ( project->cropMode == EMS_TRUE ) {
			filaL = sqrt((x1-x0)*(x1-x0) + (y1-y0)*(y1-y0));
			filaW = filaDiam / parameter.pixelSize;
		}
		else {
			filaL = abs(x1 - x0);
			filaW = abs(y1 - y0);
		}

		filaDX = filaDY = filaDL = filaDW = filaDR = 0.0;
		EMS_DP->valShftX->value(0);
		EMS_DP->valShftY->value(0);
		EMS_DP->valExtnX->value(0);
		EMS_DP->valExtnY->value(0);
		EMS_DP->valRotate->value(0);

		if ( fabs(x1-x0) > EMS_ZERO )
			filaR = atan(1.0 * (y0-y1) / (x1-x0)) * RAD2DEG;
		else
			filaR = 90.0;
	}

	// filament cropping
	if ( project->cropMode == EMS_TRUE ) {
		filaRt = filaR + filaDR;
		cosAng = cos(filaRt * DEG2RAD);
		sinAng = sin(filaRt * DEG2RAD);
		
		filaXt = filaX + filaDX * cosAng + filaDY * sinAng;
		filaYt = filaY - filaDX * sinAng + filaDY * cosAng;
		filaLt = (int)(filaL + filaDL);
		filaWt = (int)(filaW + filaDW);
		
		// update filament boxing display
		EMS_DP->imgDisplay->setFilaBoxing(filaXt, filaYt, filaLt, filaWt, filaRt);
		
		// fill in data from micrograph.density[]
		filaImg = new float[filaLt * filaWt];
		
		xc = filaLt / 2.0;
		yc = filaWt / 2.0;
		dimX = micrograph.dimX;
		dimY = micrograph.dimY;
		
		for ( y=0; y<filaWt; y++ ) {
			for ( x=0; x<filaLt; x++ ) {
				
				xf = filaXt + (x - xc) * cosAng + (y - yc) * sinAng;
				yf = filaYt + (xc - x) * sinAng + (y - yc) * cosAng;
				xm = (int)floor(xf); xp = xm + 1;
				ym = (int)floor(yf); yp = ym + 1;
				
				if ( (xm<0) || (xp>=dimX) || (ym<0) || (yp>=dimY) ) {
					filaImg[y*filaLt+x] = 0.0;
					continue;
				}
				
				dA = micrograph.density[ym * dimX + xm];
				dB = micrograph.density[ym * dimX + xp];
				dC = micrograph.density[yp * dimX + xm];
				dD = micrograph.density[yp * dimX + xp];
				dE = (xp-xf) * dA + (xf-xm) * dB;
				dF = (xp-xf) * dC + (xf-xm) * dD;
				filaImg[y*filaLt+x] = (float)((yp-yf) * dE + (yf-ym) * dF);
			}
		}
	}

	// rectangular cropping
	else {
		filaXt = filaX + filaDX;
		filaYt = filaY + filaDY;
		filaLt = (int)(filaL + filaDL);
		filaWt = (int)(filaW + filaDW);
		
		// update filament boxing display
		EMS_DP->imgDisplay->setFilaBoxing(filaXt, filaYt, filaLt, filaWt, 0.0);

		// fill in data from micrograph.density[]
		filaImg = new float[filaLt * filaWt];
		
		xc = filaXt - filaLt / 2.0;
		yc = filaYt - filaWt / 2.0;
		dimX = micrograph.dimX;
		dimY = micrograph.dimY;

		for ( y=0; y<filaWt; y++ ) {
			for ( x=0; x<filaLt; x++ ) {

				xm = (int)(x + xc);
				ym = (int)(y + yc);

				if ( (xm<0) || (xm>=dimX) || (ym<0) || (ym>=dimY) ) {
					filaImg[y*filaLt+x] = 0.0;
					continue;
				}

				filaImg[y*filaLt+x] = micrograph.density[ym * micrograph.dimX + xm];
			}
		}
	}

	// copy filaImg[] to EMS_MAP imgCrop
	imgCrop.setup(filaImg, filaLt, filaWt, 0, 0);
	cPanel->monitorFila(filaImg, filaLt, filaWt);

	delete [] filaImg;
	systemStatus(EMS_FREE);
}


void EMS_Project::findSegment(void)
{
}


void EMS_Project::traceFilament(void)
{
}


void EMS_Project::marchAlong(int tid, char flagDirct)
{
}


void EMS_Project::clearFilament(void)
{
}
