//	James Z. Chen
//	January 1, 2005
//	All rights reserved

#include "fftn.h"


void fftwN(int rank, int *dims, float *rel, float *img, int direct)
{
	int *dimen;
	long i, nSize=1;
	double scaling;
	fftw_complex *inData, *otData;
	fftw_plan plan;

	// reverse array order
	dimen = new int[rank];

	for ( i=0; i<rank; i++ ) {
		nSize *= dims[i];
		dimen[rank-1-i] = dims[i];
	}

	inData = (fftw_complex *)fftw_malloc(sizeof(fftw_complex) * nSize);
	otData = (fftw_complex *)fftw_malloc(sizeof(fftw_complex) * nSize);
	plan = fftw_plan_dft(rank, dimen, inData, otData, direct, FFTW_MEASURE);

	// input data
	for ( i=0; i<nSize; i++ ) {
		inData[i][0] = (double)(rel[i]);
		inData[i][1] = (double)(img[i]);
	}

	fftw_execute(plan);

	// output data
	scaling = 1.0 / sqrt(nSize);

	for ( i=0; i<nSize; i++ ) {
		rel[i] = (float)(otData[i][0] * scaling);
		img[i] = (float)(otData[i][1] * scaling);
	}

	fftw_destroy_plan(plan);
	fftw_free(inData);
	fftw_free(otData);
	delete [] dimen;
}
