//	James Z. Chen
//	January 1, 2005
//	All rights reserved

#ifndef __DISPLAY_H
#define __DISPLAY_H 1

#include "/usr/include/stdio.h"
#include "/usr/include/stdlib.h"
#include "../signature/include/FL/Fl.H"
#include "../signature/include/FL/Fl_Gl_Window.H"
#include "../signature/include/FL/Fl_Bitmap.H"
#include "../signature/include/FL/glut.H"

#include "platform.h"

#include "/usr/include/GL/glu.h"

#include "maps.h"


class EMS_Display : public Fl_Gl_Window {
private:
	char grxMode;			// graphics mode (2D/3D)
	int winX, winY;			// window size
	int filmX, filmY;		// film dimension to be displayed
	double zoom;			// 2D zooming factor
	double tranX, tranY;	// 2D translation parameters
	double zoom3D;			// 3D zooming factor
	double tranX3, deltaX;	// 3D translation parameters
	double tranY3, deltaY;
	double rotaH3, rotaV3;	// 3D rotation angles
	double rotaMatrix[16];	// model rotation matrix

	GLuint texFilmName;		// ID for glGenTextures()
	GLuint texMaskName;
	GLuint texRefrName;		// selected reference frame
	GLuint *texTempName;
	GLuint *texStackName;

	GLubyte *texFilm;	// RGB for film
	GLubyte *texMask;	// RGBA for mask
	GLubyte *texRefr;	// RGB for selected reference frame
	GLubyte *texTemp;	// RGB for templates
	GLubyte *texStack;	// RGB for image stack

	GLclampf grxBkgR;	// window background
	GLclampf grxBkgG;	// RGB value
	GLclampf grxBkgB;

	// highlight the current inspection
	int focusX, focusY;

	// the center of zooming
	int magX, magY;

	// ending points for line drawing
	int lineX0, lineY0, lineX1, lineY1;

	// center and radius for circle drawing
	double circX, circY, circR;

	// ending points for filament boxing, in film[] coordinates
	double filaX0, filaY0, filaX1, filaY1, filaWd;

	// arrary storing film markers
	int markNum;
	int marker[EMS_FILM_MARKER][2];

	// OpenGL display lists
	GLuint surfDispList;		// model surface
	GLuint lsetDispList;		// contour level-set

public:
	// clipping planes
	double nearPlane;		// near plane in 3D display
	double viewDepth;		// view depth = far - near

	// 3D model color
	float model_R;
	float model_G;
	float model_B;
	float model_A;

	EMS_Display(int x, int y, int w, int h, const char *l=0);
	~EMS_Display();

	// image display
    void draw(void);

	// handle interactions
	int handle(int event);

	// set graphics 2D/3D mode
	void setGraphicsMode(char gmode)
	{
		grxMode = gmode;
	}

	// initialize display parameters
	void initDisplay(int dimX, int dimY);

	// set transformation parameters
	void setZoom(int delta);
	void setTrans(int dx, int dy);
	void resetTransform(char flag);
	void resetModelView(void);

	// setup texture maps
	void setFilmTexture(EMS_MAP &map);
	void setMaskTexture(EMS_MAP &map);
	void setTempTexture(void);
	void setRefrTexture(void);
	void setStackTexture(void);

	// draw various items
	inline void drawFilm(void);
	inline void drawTemp(void);
	inline void drawMask(void);
	inline void drawPeak(void);
	inline void drawFilaTrace(void);
	inline void drawFilaBoxing(void);
	inline void setMarker(int x, int y);
	inline void drawStack(void);
	inline void drawDigitGel(void);
	inline void drawCharts(void);

	// manual selection
	void manuSelect(int x, int y);
	void coopSelect(int x, int y);
	void manuDelete(int x, int y);

	// image zooming
	inline void zoomCenter(int x, int y);
	inline void drawZoomer(void);
	void resetZoomer(void);

	// manual masking
	inline void manuLines(int x, int y, char lmode);
	inline void manuCircle(int x, int y, char cmode);
	inline void manuPaint(int x, int y);
	inline void manuErase(int x, int y);
	void maskCircle(void);

	// setup and draw the inspection focus point
	void setInspectFocus(int x, int y, char flagConvert);
	inline void drawFocus(void);

	// for CtrlPanel display
	void getFocusXY(int &x, int &y);
	void setFocusXY(int x, int y);
	void clearFocus(void);
	void getFilmDim(int &x, int &y);

	// for film marker display
	inline void drawFilmMarker(void);
	void setFilmMarker(void);
	void clearFilmMarker(void);

	// for filament boxing display
	inline void manuBoxing(int x, int y, char bmode);
	void setFilaBoxing(double xc, double yc, int length, int width, double angle);
	void clearFilaBoxing(void);

	// for template alignment centering
	inline void setAlignCenter(int x, int y);

	// for digital gel thresholding
	inline void gelThreshold(int x, int y, char state);
};


#endif
